/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.BaseAuthenticationRequest;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Set;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AuthenticationRedirectExceptionMapperTest {
    private static final int EXPECTED_STATUS = 409;
    private static final String APP_PROPS = "quarkus.http.auth.proactive=false\nquarkus.http.auth.permission.default.paths=/*\nquarkus.http.auth.permission.default.policy=authenticated";
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addAsResource((Asset)new StringAsset(APP_PROPS), "application.properties"));

    @Test
    public void testAuthenticationRedirectExceptionMapper() {
        ((ValidatableResponse)((Response)RestAssured.given().redirects().follow(false).when().get("/secured-route", new Object[0])).then()).statusCode(409);
    }

    @ApplicationScoped
    public static class BasicIdentityProvider
    implements IdentityProvider<BaseAuthenticationRequest> {
        public Class<BaseAuthenticationRequest> getRequestType() {
            return BaseAuthenticationRequest.class;
        }

        public Uni<SecurityIdentity> authenticate(BaseAuthenticationRequest simpleAuthenticationRequest, AuthenticationRequestContext authenticationRequestContext) {
            return Uni.createFrom().nothing();
        }
    }

    @ApplicationScoped
    public static class RedirectingAuthenticator
    implements HttpAuthenticationMechanism {
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            throw new AuthenticationRedirectException(302, "https://quarkus.io/");
        }

        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Set.of(BaseAuthenticationRequest.class);
        }

        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            return Uni.createFrom().item((Object)new ChallengeData(302, (CharSequence)"header-name", "header-value"));
        }
    }

    public static final class AuthenticationRedirectExceptionMapper {
        @ServerExceptionMapper(value={AuthenticationRedirectException.class})
        public jakarta.ws.rs.core.Response authenticationRedirectException() {
            return jakarta.ws.rs.core.Response.status((int)409).build();
        }
    }
}

