/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.UnauthorizedException;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CustomClassLevelExceptionMapperTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{HelloResource.class}));

    @Test
    public void shouldDenyUnannotated() {
        ((ValidatableResponse)((io.restassured.response.Response)RestAssured.when().get("hello", new Object[0])).then()).statusCode(999);
    }

    @Path(value="hello")
    @RolesAllowed(value={"test"})
    public static final class HelloResource {
        @GET
        public String hello() {
            return "hello world";
        }

        @ServerExceptionMapper(value={UnauthorizedException.class})
        public Response forbidden() {
            return Response.status((int)999).build();
        }
    }
}

