/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ResourceInfo;

@ApplicationScoped
public class CustomHttpSecurityPolicy
implements HttpSecurityPolicy {
    @Inject
    ResourceInfo resourceInfo;

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        if ("CustomPolicyResource".equals(this.resourceInfo.getResourceClass().getSimpleName()) && "isUserAdmin".equals(this.resourceInfo.getResourceMethod().getName())) {
            return identity.onItem().ifNotNull().transform(i -> {
                if (i.hasRole("user")) {
                    return new HttpSecurityPolicy.CheckResult(true, (SecurityIdentity)QuarkusSecurityIdentity.builder((SecurityIdentity)i).addRole("admin").build());
                }
                return HttpSecurityPolicy.CheckResult.PERMIT;
            });
        }
        return Uni.createFrom().item((Object)HttpSecurityPolicy.CheckResult.PERMIT);
    }

    public String name() {
        return "custom";
    }
}

