/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.PermitAllResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredParentResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredResourceInterface;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredSubResource;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DefaultRolesAllowedStarJaxRsTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{PermitAllResource.class, UnsecuredResource.class, TestIdentityProvider.class, UnsecuredResourceInterface.class, TestIdentityController.class, UnsecuredParentResource.class, UnsecuredSubResource.class})).addAsResource((Asset)new StringAsset("quarkus.security.jaxrs.default-roles-allowed = **\n"), "application.properties"));

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void shouldDenyUnannotated() {
        String path = "/unsecured/defaultSecurity";
        this.assertStatus(path, 200, 200, 401);
    }

    @Test
    public void shouldDenyDenyAllMethod() {
        String path = "/unsecured/denyAll";
        this.assertStatus(path, 403, 403, 401);
    }

    @Test
    public void shouldPermitPermitAllMethod() {
        this.assertStatus("/unsecured/permitAll", 200, 200, 200);
    }

    @Test
    public void shouldDenySubResource() {
        String path = "/unsecured/sub/subMethod";
        this.assertStatus(path, 200, 200, 401);
    }

    @Test
    public void shouldAllowPermitAllSubResource() {
        String path = "/unsecured/permitAllSub/subMethod";
        this.assertStatus(path, 200, 200, 200);
    }

    @Test
    public void shouldAllowPermitAllClass() {
        String path = "/permitAll/sub/subMethod";
        this.assertStatus(path, 200, 200, 200);
    }

    private void assertStatus(String path, int adminStatus, int userStatus, int anonStatus) {
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get(path, new Object[0])).then()).statusCode(adminStatus);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get(path, new Object[0])).then()).statusCode(userStatus);
        ((ValidatableResponse)((Response)RestAssured.when().get(path, new Object[0])).then()).statusCode(anonStatus);
    }
}

