/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.net.URL;
import java.time.Duration;
import org.awaitility.Awaitility;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class JakartaRestResourceHttpPermissionTest {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(20L);
    private static final String APP_PROPS = "quarkus.http.auth.permission.foo.paths=/api/foo,/api/foo/\nquarkus.http.auth.permission.foo.policy=authenticated\nquarkus.http.auth.permission.bar.paths=api/bar*\nquarkus.http.auth.permission.bar.policy=authenticated\nquarkus.http.auth.permission.baz-fum-pub.paths=/api/baz/fum\nquarkus.http.auth.permission.baz-fum-pub.policy=permit\nquarkus.http.auth.permission.baz-fum-deny.paths=/api/baz/fum/\nquarkus.http.auth.permission.baz-fum-deny.policy=authenticated\nquarkus.http.auth.permission.baz-fum.paths=/api/baz/fum*\nquarkus.http.auth.permission.baz-fum.policy=authenticated\nquarkus.http.auth.permission.root.paths=/\nquarkus.http.auth.permission.root.policy=authenticated\nquarkus.http.auth.permission.fragment.paths=/#stuff,/#stuff/\nquarkus.http.auth.permission.fragment.policy=authenticated\nquarkus.http.auth.permission.jax-rs.paths=jax-rs\nquarkus.http.auth.permission.jax-rs.policy=admin-role\nquarkus.http.auth.policy.admin-role.roles-allowed=admin";
    private static WebClient client;
    @RegisterExtension
    static QuarkusUnitTest runner;
    @Inject
    Vertx vertx;
    @TestHTTPResource
    URL url;

    @BeforeAll
    public static void setup() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("test", "test", new String[]{"test"});
    }

    @AfterAll
    public static void cleanup() {
        if (client != null) {
            client.close();
        }
    }

    private WebClient getClient() {
        if (client == null) {
            client = WebClient.create((Vertx)this.vertx);
        }
        return client;
    }

    @ParameterizedTest
    @ValueSource(strings={"////api/foo", "/api/foo", "/api//foo", "/api//foo", "/api///foo", "/api/foo/", "/api/foo///", "/api/foo///.", "/api/foo/./", "////api/bar", "/api///bar", "/api//bar", "/api/bar", "/api/bar/", "/api/bar/irish", "/api/bar///irish", "/api/bar///irish/.", "/../api/bar///irish/.", "/api/baz/fum/", "/api//baz/fum//", "/api//baz/fum/."})
    public void testEmptyPathSegments(String path) {
        this.assurePath(path, 401);
        this.assurePathAuthenticated(path, JakartaRestResourceHttpPermissionTest.getLastNonEmptySegmentContent(path));
    }

    @ParameterizedTest
    @ValueSource(strings={"/", "///", "/?stuff", "/#stuff/", ""})
    public void testRootPath(String path) {
        this.assurePath(path, 401);
        this.assurePathAuthenticated(path);
    }

    @ParameterizedTest
    @ValueSource(strings={"/one/", "///two", "/three?stuff", "/four#stuff", "/.////five"})
    public void testNotSecuredPaths(String path) {
        this.assurePathAuthenticated(path);
    }

    @Test
    public void testJaxRsRolesHttpSecurityPolicy() {
        this.assurePath("/jax-rs", 401);
        this.assurePath("///jax-rs///", 401);
        this.assurePath("/jax-rs", 200, "admin", true, "admin");
    }

    private static String getLastNonEmptySegmentContent(String path) {
        while (path.endsWith("/") || path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private void assurePath(String path, int expectedStatusCode) {
        this.assurePath(path, expectedStatusCode, null, false);
    }

    private void assurePathAuthenticated(String path) {
        this.assurePath(path, 200, null, true);
    }

    private void assurePathAuthenticated(String path, String body) {
        this.assurePath(path, 200, body, true);
    }

    private void assurePath(String path, int expectedStatusCode, String body, boolean auth) {
        this.assurePath(path, expectedStatusCode, body, auth, "test");
    }

    private void assurePath(String path, int expectedStatusCode, String body, boolean auth, String username) {
        HttpRequest req = this.getClient().get(this.url.getPort(), this.url.getHost(), path);
        if (auth) {
            req.basicAuthentication(username, username);
        }
        Future result = req.send();
        Awaitility.await().atMost(REQUEST_TIMEOUT).until(() -> ((Future)result).isComplete());
        Assertions.assertEquals((int)expectedStatusCode, (int)((HttpResponse)result.result()).statusCode(), (String)path);
        if (body != null) {
            Assertions.assertTrue((boolean)((HttpResponse)result.result()).bodyAsString().contains(body), (String)path);
        }
    }

    static {
        runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, ApiResource.class, RootResource.class, PublicResource.class, JaxRsResource.class})).addAsResource((Asset)new StringAsset(APP_PROPS), "application.properties"));
    }

    @Path(value="/api")
    public static class ApiResource {
        @GET
        @Path(value="/foo")
        public String foo() {
            return "foo";
        }

        @GET
        @Path(value="bar")
        public String bar() {
            return "bar";
        }

        @GET
        @Path(value="bar/irish")
        public String irishBar() {
            return "irish";
        }

        @GET
        @Path(value="baz/fum")
        public String bazFum() {
            return "fum";
        }
    }

    @Path(value="/")
    public static class RootResource {
        @GET
        public String get() {
            return "root";
        }

        @Path(value="#stuff")
        @GET
        public String fragment() {
            return "#stuff";
        }
    }

    @Path(value="/")
    public static class PublicResource {
        @Path(value="one")
        @GET
        public String one() {
            return "one";
        }

        @Path(value="/two")
        @GET
        public String two() {
            return "two";
        }

        @Path(value="/three")
        @GET
        public String three() {
            return "three";
        }

        @Path(value="four")
        @GET
        public String four() {
            return "four";
        }

        @Path(value="four#stuff")
        @GET
        public String fourFragment() {
            return "four#stuff";
        }

        @Path(value="five")
        @GET
        public String five() {
            return "five";
        }
    }

    @Path(value="jax-rs")
    public static class JaxRsResource {
        @Inject
        SecurityIdentity identity;

        @GET
        public String getPrincipalName() {
            return this.identity.getPrincipal().getName();
        }
    }
}

