/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.PermitAllBlockingResource;
import io.quarkus.resteasy.reactive.server.test.security.PermitAllResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredSubResource;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class LazyAuthPermitAllJaxRsTestCase {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{PermitAllResource.class, PermitAllBlockingResource.class, TestIdentityProvider.class, TestIdentityController.class, UnsecuredSubResource.class})).addAsResource((Asset)new StringAsset("quarkus.http.auth.proactive=false\n"), "application.properties"));

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void testPermitAll() {
        Arrays.asList("/permitAll/defaultSecurity", "/permitAll/sub/subMethod").forEach(path -> {
            ((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "wrong").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("wrong", "wrong").get(path, new Object[0])).then()).statusCode(200);
        });
    }

    @Test
    public void testPermitAllBlocking() {
        Arrays.asList("/permitAllBlocking/defaultSecurity", "/permitAllBlocking/sub/subMethod").forEach(path -> {
            ((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "wrong").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("wrong", "wrong").get(path, new Object[0])).then()).statusCode(200);
        });
    }
}

