/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.CustomPermission;
import io.quarkus.resteasy.reactive.server.test.security.CustomPermissionWithExtraArgs;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.jboss.resteasy.reactive.RestCookie;
import org.jboss.resteasy.reactive.RestHeader;
import org.jboss.resteasy.reactive.RestPath;

@Path(value="/permissions-non-blocking")
@PermitAll
public class NonBlockingPermissionsAllowedResource {
    @Inject
    CurrentIdentityAssociation currentIdentityAssociation;

    @POST
    @PermissionsAllowed.List(value={@PermissionsAllowed(value={"create"}), @PermissionsAllowed(value={"update"})})
    public Uni<String> createOrUpdate() {
        return Uni.createFrom().item((Object)"done");
    }

    @Path(value="/admin")
    @PermissionsAllowed(value={"read:resource-admin", "read:resource-user"})
    @GET
    public Uni<String> admin() {
        return Uni.createFrom().item((Object)"admin");
    }

    @Path(value="/admin/security-identity")
    @PermissionsAllowed(value={"get-identity"})
    @GET
    public Uni<String> getSecurityIdentity() {
        return Uni.createFrom().item((Object)this.currentIdentityAssociation.getIdentity().getPrincipal().getName());
    }

    @PermissionsAllowed(value={"perm1"}, permission=CustomPermission.class)
    @Path(value="/custom-permission")
    @GET
    public Uni<String> greetings(@QueryParam(value="greeting") String greeting) {
        return Uni.createFrom().item((Object)greeting);
    }

    @PermissionsAllowed(value={"farewell"}, permission=CustomPermissionWithExtraArgs.class)
    @Path(value="/custom-perm-with-args/{goodbye}")
    @POST
    public Uni<String> farewell(@RestPath String goodbye, @RestHeader(value="toWhom") String toWhom, @RestCookie int day, String place) {
        String farewell = String.join((CharSequence)" ", goodbye, toWhom, Integer.toString(day), place);
        return Uni.createFrom().item((Object)farewell);
    }
}

