/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.CustomPermission;
import io.quarkus.resteasy.reactive.server.test.security.CustomPermissionWithExtraArgs;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.jboss.resteasy.reactive.RestCookie;
import org.jboss.resteasy.reactive.RestHeader;
import org.jboss.resteasy.reactive.RestPath;

@Path(value="/permissions")
public class PermissionsAllowedResource {
    @Inject
    CurrentIdentityAssociation currentIdentityAssociation;

    @POST
    @PermissionsAllowed.List(value={@PermissionsAllowed(value={"create"}), @PermissionsAllowed(value={"update"})})
    public String createOrUpdate() {
        return "done";
    }

    @Path(value="/admin")
    @PermissionsAllowed(value={"read:resource-admin"})
    @GET
    public String admin() {
        return "admin";
    }

    @NonBlocking
    @Path(value="/admin/security-identity")
    @PermissionsAllowed(value={"get-identity"})
    @GET
    public String getSecurityIdentity() {
        return this.currentIdentityAssociation.getIdentity().getPrincipal().getName();
    }

    @PermissionsAllowed(value={"perm1"}, permission=CustomPermission.class)
    @Path(value="/custom-permission")
    @GET
    public String greetings(@QueryParam(value="greeting") String greeting) {
        return greeting;
    }

    @PermissionsAllowed(value={"farewell"}, permission=CustomPermissionWithExtraArgs.class, params={"goodbye", "toWhom", "day", "place"})
    @Path(value="/custom-perm-with-args/{goodbye}")
    @POST
    public String farewell(@RestPath String goodbye, @RestHeader(value="toWhom") String toWhom, @RestCookie int day, String place) {
        String farewell = String.join((CharSequence)" ", goodbye, toWhom, Integer.toString(day), place);
        return farewell;
    }
}

