/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.cookie.CookieFilter;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ProactiveAuthCompletionExceptionMapperTest {
    private static final String AUTHENTICATION_COMPLETION_EX = "AuthenticationCompletionException";
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, CustomAuthCompletionExceptionMapper.class})).addAsResource((Asset)new StringAsset("quarkus.http.auth.form.enabled=true\n"), "application.properties");
        }
    });

    @BeforeAll
    public static void setup() {
        TestIdentityController.resetRoles().add("a d m i n", "a d m i n", new String[]{"a d m i n"});
    }

    @Test
    public void testAuthCompletionExMapper() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().filter((Filter)new CookieFilter()).redirects().follow(false).when().formParam("j_username", new Object[]{"a d m i n"}).formParam("j_password", new Object[]{"a d m i n"}).cookie("quarkus-redirect-location", (Object)"https://quarkus.io/guides", new Object[0]).post("/j_security_check", new Object[0])).then()).assertThat()).statusCode(401)).body(Matchers.equalTo((Object)AUTHENTICATION_COMPLETION_EX), new Matcher[0]);
    }

    public static final class CustomAuthCompletionExceptionMapper {
        @ServerExceptionMapper(value={AuthenticationCompletionException.class})
        public jakarta.ws.rs.core.Response unauthorized() {
            return jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ProactiveAuthCompletionExceptionMapperTest.AUTHENTICATION_COMPLETION_EX).build();
        }
    }
}

