/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedResource;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RemoteUserHttpAccessLogTest {
    @RegisterExtension
    public static QuarkusUnitTest unitTest = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)((JavaArchive)jar.addClasses(new Class[]{RolesAllowedResource.class, SecurityOverrideFilter.class})).addClasses(new Class[]{TestIdentityController.class, TestIdentityProvider.class})).add((Asset)new StringAsset("quarkus.http.access-log.enabled=true\nquarkus.http.access-log.pattern=%h %t %u"), "application.properties")).setLogRecordPredicate(logRecord -> logRecord.getLevel().equals(Level.INFO) && logRecord.getLoggerName().equals("io.quarkus.http.access-log")).assertLogRecords(logRecords -> {
        List accessLogRecords = logRecords.stream().map(LogRecord::getMessage).collect(Collectors.toList());
        Assertions.assertTrue((boolean)accessLogRecords.stream().anyMatch(msg -> msg.endsWith("admin")));
        Assertions.assertFalse((boolean)accessLogRecords.stream().anyMatch(msg -> msg.endsWith("user")));
        Assertions.assertTrue((boolean)accessLogRecords.stream().anyMatch(msg -> msg.endsWith("Charlie")));
    });

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void testAuthRemoteUserLogged() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/roles", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"default"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get("/roles", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"default"), new Matcher[0]);
    }

    @Provider
    @PreMatching
    public static class SecurityOverrideFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (requestContext.getSecurityContext().getUserPrincipal().getName().equals("user")) {
                requestContext.setSecurityContext(new SecurityContext(){

                    public Principal getUserPrincipal() {
                        return new Principal(){

                            @Override
                            public String getName() {
                                return "Charlie";
                            }
                        };
                    }

                    public boolean isUserInRole(String r) {
                        return "user".equals(r);
                    }

                    public boolean isSecure() {
                        return false;
                    }

                    public String getAuthenticationScheme() {
                        return "basic";
                    }
                });
            }
        }
    }
}

