/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedBlockingResource;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedResource;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedService;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedServiceResource;
import io.quarkus.resteasy.reactive.server.test.security.SerializationEntity;
import io.quarkus.resteasy.reactive.server.test.security.SerializationRolesResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredSubResource;
import io.quarkus.resteasy.reactive.server.test.security.UserResource;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RolesAllowedJaxRsTestCase {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{RolesAllowedResource.class, UserResource.class, RolesAllowedBlockingResource.class, SerializationEntity.class, SerializationRolesResource.class, TestIdentityProvider.class, TestIdentityController.class, UnsecuredSubResource.class, RolesAllowedService.class, RolesAllowedServiceResource.class}));
    static volatile boolean read = false;

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void testRolesAllowed() {
        Arrays.asList("/roles", "/roles-blocking").forEach(path -> {
            ((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(401);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get(path + "/admin", new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get(path + "/admin", new Object[0])).then()).statusCode(403);
        });
    }

    @Test
    public void testUser() {
        ((ValidatableResponse)RestAssured.get((String)"/user", (Object[])new Object[0]).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/user", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"admin"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/user", new Object[0])).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/user", new Object[0])).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get("/user", new Object[0])).then()).body(Matchers.is((Object)"user"), new Matcher[0]);
    }

    @Test
    public void testNestedRolesAllowed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/roles-service/hello", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello from Service!"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/roles-service/hello", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testSecurityRunsBeforeValidation() {
        read = false;
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)new SerializationEntity()).post("/roles-validate", new Object[0])).then()).statusCode(401);
        Assertions.assertFalse((boolean)read);
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)new SerializationEntity()).auth().basic("admin", "admin").post("/roles-validate", new Object[0])).then()).statusCode(200);
        Assertions.assertTrue((boolean)read);
        read = false;
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)new SerializationEntity()).auth().basic("user", "user").post("/roles-validate", new Object[0])).then()).statusCode(200);
        Assertions.assertTrue((boolean)read);
        read = false;
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)new SerializationEntity()).auth().basic("admin", "admin").post("/roles-validate/admin", new Object[0])).then()).statusCode(200);
        Assertions.assertTrue((boolean)read);
        read = false;
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)new SerializationEntity()).auth().basic("user", "user").post("/roles-validate/admin", new Object[0])).then()).statusCode(403);
        Assertions.assertFalse((boolean)read);
    }

    @Provider
    public static class Reader
    implements MessageBodyReader<SerializationEntity> {
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public SerializationEntity readFrom(Class<SerializationEntity> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            read = true;
            SerializationEntity entity = new SerializationEntity();
            entity.setName("read");
            return entity;
        }
    }
}

