/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Singleton
public class TestTrustedIdentityProvider
implements IdentityProvider<TrustedAuthenticationRequest> {
    public Class<TrustedAuthenticationRequest> getRequestType() {
        return TrustedAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(TrustedAuthenticationRequest request, AuthenticationRequestContext context) {
        if (HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request) == null) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
        }
        TestIdentityController.TestIdentity ident = (TestIdentityController.TestIdentity)TestIdentityController.identities.get(request.getPrincipal());
        if (ident == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        return Uni.createFrom().completionStage(CompletableFuture.completedFuture(QuarkusSecurityIdentity.builder().setPrincipal((Principal)new QuarkusPrincipal(request.getPrincipal())).addRoles(ident.roles).build()));
    }
}

