/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ApplicationPathTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestApplication.class, HelloResource.class});
        }
    });

    @Test
    public void helloTest() {
        ((ValidatableResponse)RestAssured.get((String)"/app/hello", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"hello"), new Matcher[0]);
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String hello() {
            return "hello";
        }
    }

    @ApplicationPath(value="app")
    public static class TestApplication
    extends Application {
    }
}

