/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.common.annotation.Blocking;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class BlockingWithFilterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestFilter.class, TestResource.class});
        }
    });

    @Test
    public void requestFilterTest() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/request", (Object[])new Object[0]).then()).statusCode(200)).contentType("text/plain")).extract().body().asString();
        String[] parts = response.split("/");
        Assertions.assertEquals((int)2, (int)parts.length);
        Assertions.assertEquals((Object)parts[0], (Object)parts[1]);
        Assertions.assertFalse((boolean)parts[0].contains("eventloop"));
        Assertions.assertTrue((boolean)parts[0].contains("executor"));
    }

    @Path(value="/test")
    public static class TestResource {
        @Blocking
        @Path(value="/request")
        @GET
        public String get(@Context HttpHeaders headers) {
            return headers.getHeaderString("filter-thread") + "/" + Thread.currentThread().getName();
        }
    }

    public static class TestFilter {
        @ServerRequestFilter
        public void filter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"filter-thread", (Object)Thread.currentThread().getName());
        }
    }
}

