/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.arc.profile.UnlessBuildProfile;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.arc.properties.UnlessBuildProperty;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class BuildProfileTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{ResourceTest1.class, ResourceTest2.class, ResponseFilter1.class, ResponseFilter2.class, ResponseFilter3.class, ResponseFilter4.class, ResponseFilter5.class, ResponseFilter6.class, Feature1.class, Feature2.class, DynamicFeature1.class, DynamicFeature2.class, ExceptionMapper1.class, ExceptionMapper2.class})).overrideConfigKey("some.prop1", "v1").overrideConfigKey("some.prop2", "v2");

    BuildProfileTest() {
    }

    @DisplayName(value="Should access to ok of resource 1 and provide a response with the expected headers")
    @Test
    void should_call_ok_of_resource_1() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/rt-1/ok", new Object[0])).then()).header("X-RF-1", Matchers.notNullValue())).header("X-RF-2", Matchers.nullValue())).header("X-RF-3", Matchers.notNullValue())).header("X-RF-4", Matchers.nullValue())).header("X-RF-5", Matchers.notNullValue())).header("X-RF-6", Matchers.nullValue())).header("X-RF-7", Matchers.notNullValue())).body(Matchers.is((Object)"ok1"), new Matcher[0]);
    }

    @DisplayName(value="Should access to ko of resource 1 and call the expected exception mapper")
    @Test
    void should_call_ko_of_resource_1() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/rt-1/ko", new Object[0])).then()).statusCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
    }

    @DisplayName(value="Should access to ok of resource 1 and provide a response with the expected headers")
    @Test
    void should_not_call_ok_of_resource_2() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/rt-2/ok", new Object[0])).then()).statusCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
    }

    @IfBuildProfile(value="test")
    @Path(value="rt-1")
    public static class ResourceTest1 {
        @GET
        @Path(value="ok")
        public String ok() {
            return "ok1";
        }

        @GET
        @Path(value="ko")
        public String ko() {
            throw new UnsupportedOperationException();
        }
    }

    @IfBuildProfile(value="foo")
    @Path(value="rt-2")
    public static class ResourceTest2 {
        @GET
        @Path(value="ok")
        public String ok() {
            return "ok2";
        }
    }

    @IfBuildProperty(name="some.prop1", stringValue="v1")
    @Provider
    public static class ResponseFilter1
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-1", (Object)"Value");
        }
    }

    @IfBuildProperty(name="some.prop1", stringValue="v")
    @Provider
    public static class ResponseFilter2
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-2", (Object)"Value");
        }
    }

    @IfBuildProfile(value="test")
    @UnlessBuildProperty(name="some.prop2", stringValue="v1")
    @Provider
    public static class ResponseFilter3
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-3", (Object)"Value");
        }
    }

    @UnlessBuildProperty(name="some.prop2", stringValue="v2")
    @Provider
    public static class ResponseFilter4
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-4", (Object)"Value");
        }
    }

    @IfBuildProfile(value="test")
    @Provider
    public static class ResponseFilter5
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-5", (Object)"Value");
        }
    }

    @IfBuildProfile(value="bar")
    @Provider
    public static class ResponseFilter6
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-6", (Object)"Value");
        }
    }

    @IfBuildProfile(value="test")
    @Provider
    public static class Feature1
    implements Feature {
        public boolean configure(FeatureContext context) {
            context.register(ResponseFilter3.class);
            return true;
        }
    }

    @UnlessBuildProfile(value="test")
    @Provider
    public static class Feature2
    implements Feature {
        public boolean configure(FeatureContext context) {
            context.register(ResponseFilter4.class);
            return true;
        }
    }

    @IfBuildProfile(value="test")
    @Provider
    public static class DynamicFeature1
    implements DynamicFeature {
        public void configure(ResourceInfo resourceInfo, FeatureContext context) {
            context.register(ResponseFilter5.class);
            context.register((Object)new ResponseFilter7("Value"));
        }
    }

    @IfBuildProfile(value="bar")
    @Provider
    public static class DynamicFeature2
    implements DynamicFeature {
        public void configure(ResourceInfo resourceInfo, FeatureContext context) {
            context.register(ResponseFilter6.class);
        }
    }

    @IfBuildProfile(value="test")
    @Provider
    public static class ExceptionMapper1
    implements ExceptionMapper<RuntimeException> {
        public jakarta.ws.rs.core.Response toResponse(RuntimeException exception) {
            return jakarta.ws.rs.core.Response.status((int)Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).build();
        }
    }

    @UnlessBuildProfile(value="test")
    @Provider
    public static class ExceptionMapper2
    implements ExceptionMapper<UnsupportedOperationException> {
        public jakarta.ws.rs.core.Response toResponse(UnsupportedOperationException exception) {
            return jakarta.ws.rs.core.Response.status((int)Response.Status.NOT_IMPLEMENTED.getStatusCode()).build();
        }
    }

    public static class ResponseFilter7
    implements ContainerResponseFilter {
        private final String value;

        public ResponseFilter7(String value) {
            this.value = value;
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"X-RF-7", (Object)this.value);
        }
    }
}

