/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CustomContextTypeTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestResource.class, CustomType.class, CustomTypeProducer.class});
        }
    });

    @Test
    public void firstTest() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers("foo", (Object)"bar", new Object[0]).get("/test", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"bar"), new Matcher[0]);
    }

    @Test
    public void secondTest() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers("foo", (Object)"baz", new Object[0]).get("/test", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"baz"), new Matcher[0]);
    }

    @Singleton
    public static class CustomTypeProducer {
        @Produces
        @RequestScoped
        public CustomType customType(HttpHeaders headers) {
            return new CustomType(headers.getHeaderString("foo"));
        }
    }

    public static class CustomType {
        private final String value;

        public CustomType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @Path(value="/test")
    public static class TestResource {
        @GET
        public String get(@Context CustomType customType) {
            return customType.getValue();
        }
    }
}

