/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.resteasy.reactive.server.test.simple.SimpleBeanParam;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import org.junit.jupiter.api.Assertions;

@Path(value="injection")
public class FieldInjectedResource {
    @QueryParam(value="query")
    String query;
    @HeaderParam(value="header")
    String header;
    @Context
    UriInfo uriInfo;
    @BeanParam
    SimpleBeanParam beanParam;

    @Path(value="field")
    @GET
    public String field() {
        this.checkInjections("/injection/field", this.query, this.header, this.uriInfo, this.beanParam);
        return "OK";
    }

    protected void checkInjections(String path, String query, String header, UriInfo uriInfo, SimpleBeanParam beanParam) {
        Assertions.assertEquals((Object)"one-query", (Object)query);
        Assertions.assertEquals((Object)"one-header", (Object)header);
        Assertions.assertNotNull((Object)uriInfo);
        Assertions.assertEquals((Object)path, (Object)uriInfo.getPath());
        Assertions.assertNotNull((Object)beanParam);
        beanParam.check(path);
    }

    @Path(value="param")
    @GET
    public String param(@QueryParam(value="query") String query, @HeaderParam(value="header") String header, @Context UriInfo uriInfo, @BeanParam SimpleBeanParam beanParam) {
        this.checkInjections("/injection/param", query, header, uriInfo, beanParam);
        return "OK";
    }
}

