/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class GenericsParamConverterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{TestEnum.class, Wrapper.class, WrapperParamConverterProvider.class, WrapperParamConverterProvider.WrapperParamConverter.class, TestResource.class}));

    @Test
    public void wrapper() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/test/single?wrapper=ACTIVE", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"ACTIVE"), new Matcher[0]);
    }

    @Test
    public void wrapperList() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/test/list?wrapperList=INACTIVE&wrapperList=ACTIVE", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"INACTIVE,ACTIVE"), new Matcher[0]);
    }

    public static enum TestEnum {
        ACTIVE,
        INACTIVE;

    }

    public static class Wrapper<E extends Enum<E>> {
        private final E value;

        public Wrapper(E value) {
            this.value = value;
        }

        public E getValue() {
            return this.value;
        }
    }

    @Provider
    public static class WrapperParamConverterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (Wrapper.class.isAssignableFrom(rawType)) {
                return new WrapperParamConverter();
            }
            return null;
        }

        public static class WrapperParamConverter
        implements ParamConverter<Wrapper<?>> {
            public Wrapper<?> fromString(String value) {
                return new Wrapper<TestEnum>(Enum.valueOf(TestEnum.class, value));
            }

            public String toString(Wrapper<?> wrapper) {
                return wrapper != null ? ((Enum)wrapper.getValue()).toString() : null;
            }
        }
    }

    @Path(value="/test")
    public static class TestResource {
        @GET
        @Path(value="/list")
        public String list(@QueryParam(value="wrapperList") List<Wrapper<TestEnum>> wrapperList) {
            return wrapperList.stream().map(w -> ((TestEnum)((Object)((Object)w.getValue()))).name()).collect(Collectors.joining(","));
        }

        @GET
        @Path(value="/single")
        public String single(@QueryParam(value="wrapper") Wrapper<TestEnum> wrapper) {
            return wrapper.getValue().toString();
        }
    }
}

