/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.time.LocalDate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class LocalDateParamTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{HelloResource.class}));

    @Test
    public void localDateAsQueryParam() {
        ((ValidatableResponse)RestAssured.get((String)"/hello?date=1984-08-08", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"hello#1984-08-08"), new Matcher[0]);
    }

    @Test
    public void localDateAsPathParam() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/1995-09-21", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"hello@1995-09-21"), new Matcher[0]);
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String helloQuery(@QueryParam(value="date") LocalDate date) {
            return "hello#" + date;
        }

        @GET
        @Path(value="{date}")
        public String helloPath(@PathParam(value="date") LocalDate date) {
            return "hello@" + date;
        }
    }
}

