/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MapWithParamConverterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{HelloResource.class, MapParamConverter.class, MapParamConverterProvider.class}));

    @Test
    public void noQueryParams() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)""), new Matcher[0]);
    }

    @Test
    public void jsonQueryParam() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("param", new Object[]{"{\"a\":\"1\",\"b\":\"2\"}"}).get("/hello", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"a:1-b:2"), new Matcher[0]);
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        @Produces(value={"text/plain"})
        public String hello(@RestQuery(value="param") Map<String, Integer> names) {
            return Optional.ofNullable(names).orElse(Map.of()).entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining("-"));
        }
    }

    static class MapParamConverter<T>
    implements ParamConverter<T> {
        Class<T> rawType;
        JavaType genericType;
        ObjectMapper objectMapper = new ObjectMapper();

        public MapParamConverter(Class<T> rawType, Type genericType) {
            this.genericType = genericType != null ? TypeFactory.defaultInstance().constructType(genericType) : null;
            this.rawType = rawType;
        }

        public T fromString(String value) {
            if (this.rawType.isAssignableFrom(String.class)) {
                return (T)value;
            }
            try {
                return (T)(this.genericType != null ? this.objectMapper.readValue(value, this.genericType) : this.objectMapper.readValue(value, this.rawType));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString(T value) {
            if (this.rawType.isAssignableFrom(String.class)) {
                return (String)value;
            }
            try {
                return this.objectMapper.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Provider
    static class MapParamConverterProvider
    implements ParamConverterProvider {
        MapParamConverterProvider() {
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType == Map.class) {
                return new MapParamConverter<T>(rawType, genericType);
            }
            return null;
        }
    }
}

