/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.common.annotation.Blocking;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.Optional;
import org.jboss.resteasy.reactive.RestCookie;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.RestHeader;
import org.jboss.resteasy.reactive.RestMatrix;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.junit.jupiter.api.Assertions;

@Path(value="/new-params/{klass}/{regex:[^/]+}")
public class NewParamsRestResource {
    @GET
    @Path(value="{id}")
    public String get(String klass, String regex, String id) {
        return "GET:" + klass + ":" + regex + ":" + id;
    }

    @POST
    @Path(value="params/{p}")
    public String params(@RestPath String p, @RestQuery String q, @RestQuery Optional<String> q2, @RestQuery Optional<Integer> q3, @RestHeader int h, @RestHeader String xMyHeader, @RestHeader(value="Test-Header-Param") String testHeaderParam, @RestHeader(value="") String paramEmpty, @RestForm String f, @RestMatrix String m, @RestCookie String c) {
        return "params: p: " + p + ", q: " + q + ", h: " + h + ", xMyHeader: " + xMyHeader + ", testHeaderParam: " + testHeaderParam + ", paramEmpty: " + paramEmpty + ", f: " + f + ", m: " + m + ", c: " + c + ", q2: " + q2.orElse("empty") + ", q3: " + q3.orElse(-1);
    }

    @Blocking
    @POST
    @Path(value="form-blocking")
    public String formBlocking(@RestForm String f) {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        return f;
    }

    @GET
    @Path(value="context")
    public String context(UriInfo uriInfo, HttpHeaders headers, Request request, Providers providers, ResourceContext resourceContext, Configuration configuration, ResourceInfo resourceInfo, SimpleResourceInfo simplifiedResourceInfo, ServerRequestContext restContext, HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        Assertions.assertNotNull((Object)uriInfo);
        Assertions.assertNotNull((Object)headers);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)providers);
        Assertions.assertNotNull((Object)resourceContext);
        Assertions.assertNotNull((Object)configuration);
        Assertions.assertNotNull((Object)resourceInfo);
        Assertions.assertNotNull((Object)simplifiedResourceInfo);
        Assertions.assertNotNull((Object)restContext);
        Assertions.assertNotNull((Object)httpServerRequest);
        Assertions.assertNotNull((Object)httpServerResponse);
        return "OK";
    }

    @GET
    @Path(value="sse")
    @Produces(value={"text/event-stream"})
    public void eventStream(SseEventSink eventSink, Sse sse) {
        Assertions.assertNotNull((Object)eventSink);
        Assertions.assertNotNull((Object)sse);
        try (SseEventSink sink = eventSink;){
            eventSink.send(sse.newEvent("OK"));
        }
    }
}

