/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;

@Path(value="/optional-query/greetings")
public class OptionalQueryParamResource {
    public static final String HELLO = "hello ";
    public static final String NOBODY = "nobody";
    public static final String AND = " and ";

    @Path(value="/one")
    @GET
    public String sayHelloToValue(@QueryParam(value="name") Optional<String> name) {
        return HELLO + name.orElse(NOBODY);
    }

    @Path(value="/list")
    @GET
    public String sayHelloToList(@QueryParam(value="name") Optional<List<String>> names) {
        return this.doSayHelloToCollection(names);
    }

    @Path(value="/set")
    @GET
    public String sayHelloToSet(@QueryParam(value="name") Optional<Set<String>> names) {
        return this.doSayHelloToCollection(names);
    }

    @Path(value="/sortedset")
    @GET
    public String sayHelloToSortedSet(@QueryParam(value="name") Optional<SortedSet<String>> names) {
        return this.doSayHelloToCollection(names);
    }

    private String doSayHelloToCollection(Optional<? extends Collection<String>> names) {
        return HELLO + names.map(l -> l.stream().collect(Collectors.joining(AND))).orElse(NOBODY);
    }
}

