/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestQuery;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RawListQueryParamTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClass(HelloResource.class));

    @Test
    public void noQueryParams() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello world"), new Matcher[0]);
    }

    @Test
    public void singleQueryParam() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello?name=foo", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello foo"), new Matcher[0]);
    }

    @Test
    public void multipleQueryParams() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello?name=foo&name=bar", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello foo,bar"), new Matcher[0]);
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String hello(@RestQuery(value="name") List names) {
            if (names.isEmpty()) {
                return "hello world";
            }
            return "hello " + String.join((CharSequence)",", names);
        }
    }
}

