/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.Separator;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SeparatorQueryParamTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClass(HelloResource.class));

    @Test
    public void noQueryParams() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello world"), new Matcher[0])).header("x-size", "0");
    }

    @Test
    public void noQueryParamsBean() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello/bean", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello world"), new Matcher[0])).header("x-size", "0");
    }

    @Test
    public void singleQueryParam() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello?name=foo", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello foo"), new Matcher[0])).header("x-size", "1");
    }

    @Test
    public void singleQueryParamBean() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello/bean?name=foo", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello foo"), new Matcher[0])).header("x-size", "1");
    }

    @Test
    public void multipleQueryParams() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello?name=foo,bar&name=one,two,three&name=yolo", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello foo bar one two three yolo"), new Matcher[0])).header("x-size", "6");
    }

    @Test
    public void multipleQueryParamsBean() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello/bean?name=foo,bar&name=one,two,three&name=yolo", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello foo bar one two three yolo"), new Matcher[0])).header("x-size", "6");
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public RestResponse<String> hello(@RestQuery(value="name") @Separator(value=",") List<String> names) {
            return this.toResponse(names);
        }

        @GET
        @Path(value="bean")
        public RestResponse<String> helloBean(@BeanParam Bean bean) {
            return this.toResponse(bean.names);
        }

        private RestResponse<String> toResponse(List<String> names) {
            int size = names.size();
            Object body = "";
            body = names.isEmpty() ? "hello world" : "hello " + String.join((CharSequence)" ", names);
            return RestResponse.ResponseBuilder.ok((Object)body).header("x-size", (Object)size).build();
        }
    }

    public static class Bean {
        @RestQuery(value="name")
        @Separator(value=",")
        public List<String> names;
    }
}

