/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.resteasy.reactive.server.test.simple.Bar;
import io.quarkus.resteasy.reactive.server.test.simple.FeatureMappedException;
import io.quarkus.resteasy.reactive.server.test.simple.Foo;
import io.quarkus.resteasy.reactive.server.test.simple.HelloService;
import io.quarkus.resteasy.reactive.server.test.simple.Person;
import io.quarkus.resteasy.reactive.server.test.simple.SubResource;
import io.quarkus.resteasy.reactive.server.test.simple.TRACE;
import io.quarkus.resteasy.reactive.server.test.simple.TestClass;
import io.quarkus.resteasy.reactive.server.test.simple.TestException;
import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Providers;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.RestHeader;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;

@Path(value="/simple")
public class SimpleQuarkusRestResource {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    @Inject
    HelloService service;

    @GET
    public String get() {
        return "GET";
    }

    @Path(value="sub")
    public Object subResource() {
        return new SubResource();
    }

    @GET
    @Path(value="/hello")
    public String hello() {
        return this.service.sayHello();
    }

    @GET
    @Path(value="{id}")
    public String get(@PathParam(value="id") String id) {
        return "GET:" + id;
    }

    @POST
    @Path(value="params/{p}")
    public String params(@PathParam(value="p") String p, @QueryParam(value="q") String q, @HeaderParam(value="h") int h, @FormParam(value="f") String f) {
        return "params: p: " + p + ", q: " + q + ", h: " + h + ", f: " + f;
    }

    @POST
    public String post() {
        return "POST";
    }

    @DELETE
    public String delete() {
        return "DELETE";
    }

    @PUT
    public String put() {
        return "PUT";
    }

    @PATCH
    public String patch() {
        return "PATCH";
    }

    @OPTIONS
    public String options() {
        return "OPTIONS";
    }

    @HEAD
    public Response head() {
        return Response.ok().header("Stef", (Object)"head").build();
    }

    @GET
    @Path(value="/person")
    @Produces(value={"application/json"})
    public Person getPerson() {
        Person person = new Person();
        person.setFirst("Bob");
        person.setLast("Builder");
        return person;
    }

    @GET
    @Path(value="/blocking")
    @Blocking
    public String blocking() {
        this.service.sayHello();
        return String.valueOf(BlockingOperationControl.isBlockingAllowed());
    }

    @GET
    @Path(value="providers")
    public Response filters(@Context Providers providers) {
        return Response.ok().entity((Object)providers.getExceptionMapper(TestException.class).getClass().getName()).build();
    }

    @GET
    @Path(value="filters")
    public Response filters(@Context HttpHeaders headers, @RestHeader(value="filter-request") String header) {
        return Response.ok().header("filter-request", (Object)header).build();
    }

    @GET
    @Path(value="header-param-list")
    public Object headerParamWithList(@HeaderParam(value="header") List list) {
        return this.collectionToString(list);
    }

    @GET
    @Path(value="rest-header-list")
    public Object restHeaderWithList(@RestHeader List header) {
        return this.collectionToString(header);
    }

    @GET
    @Path(value="header-param-set")
    public Object headerParamWithSet(@HeaderParam(value="header") Set list) {
        return this.collectionToString(list);
    }

    @GET
    @Path(value="rest-header-set")
    public Object restHeaderWithSet(@RestHeader Set header) {
        return this.collectionToString(header);
    }

    @GET
    @Path(value="header-param-sorted-set")
    public Object headerParamWithSortedSet(@HeaderParam(value="header") SortedSet list) {
        return this.collectionToString(list);
    }

    @GET
    @Path(value="rest-header-sorted-set")
    public String restHeaderWithSortedSet(@RestHeader SortedSet header) {
        return this.collectionToString(header);
    }

    @GET
    @Path(value="feature-filters")
    public Response featureFilters(@Context HttpHeaders headers) {
        return Response.ok().header("feature-filter-request", (Object)headers.getHeaderString("feature-filter-request")).build();
    }

    @GET
    @Path(value="dynamic-feature-filters")
    public Response dynamicFeatureFilters(@Context HttpHeaders headers) {
        return Response.ok().header("feature-filter-request", (Object)headers.getHeaderString("feature-filter-request")).build();
    }

    @GET
    @Path(value="fooFilters")
    @Foo
    public Response fooFilters(@Context HttpHeaders headers) {
        return Response.ok().header("filter-request", (Object)headers.getHeaderString("filter-request")).build();
    }

    @GET
    @Path(value="barFilters")
    @Bar
    public Response barFilters(@Context HttpHeaders headers) {
        return Response.ok().header("filter-request", (Object)headers.getHeaderString("filter-request")).build();
    }

    @GET
    @Path(value="fooBarFilters")
    @Foo
    @Bar
    public Response fooBarFilters(@Context HttpHeaders headers) {
        return Response.ok().header("filter-request", (Object)headers.getHeaderString("filter-request")).build();
    }

    @GET
    @Path(value="mapped-exception")
    public String mappedException() {
        TestException exception = new TestException();
        exception.setStackTrace(EMPTY_STACK_TRACE);
        throw exception;
    }

    @GET
    @Path(value="feature-mapped-exception")
    public String featureMappedException() {
        FeatureMappedException exception = new FeatureMappedException();
        exception.setStackTrace(EMPTY_STACK_TRACE);
        throw exception;
    }

    @GET
    @Path(value="unknown-exception")
    public String unknownException() {
        RuntimeException exception = new RuntimeException("OUCH");
        exception.setStackTrace(EMPTY_STACK_TRACE);
        throw exception;
    }

    @GET
    @Path(value="web-application-exception")
    public String webApplicationException() {
        throw new WebApplicationException(Response.status((int)666).entity((Object)"OK").build());
    }

    @GET
    @Path(value="writer")
    public TestClass writer() {
        return new TestClass();
    }

    @GET
    @Path(value="fast-writer")
    @Produces(value={"text/plain"})
    public String fastWriter() {
        return "OK";
    }

    @GET
    @Path(value="lookup-writer")
    public Object slowWriter() {
        return "OK";
    }

    @GET
    @Path(value="writer/vertx-buffer")
    public Buffer vertxBuffer() {
        return Buffer.buffer((String)"VERTX-BUFFER");
    }

    @GET
    @Path(value="writer/mutiny-buffer")
    public io.vertx.mutiny.core.buffer.Buffer mutinyBuffer() {
        return io.vertx.mutiny.core.buffer.Buffer.buffer((String)"MUTINY-BUFFER");
    }

    @GET
    @Path(value="async/cs/ok")
    public CompletionStage<String> asyncCompletionStageOK() {
        return CompletableFuture.completedFuture("CS-OK");
    }

    @GET
    @Path(value="async/cs/fail")
    public CompletionStage<String> asyncCompletionStageFail() {
        CompletableFuture<String> ret = new CompletableFuture<String>();
        ret.completeExceptionally(new TestException());
        return ret;
    }

    @GET
    @Path(value="async/cf/blocking")
    public CompletableFuture<String> asyncCompletableFutureIsBlocking() {
        return CompletableFuture.completedFuture(Boolean.toString(BlockingOperationControl.isBlockingAllowed()));
    }

    @GET
    @Path(value="async/cf/ok")
    public CompletableFuture<String> asyncCompletableFutureOK() {
        return CompletableFuture.completedFuture("CF-OK");
    }

    @GET
    @Path(value="async/cf/fail")
    public CompletableFuture<String> asyncCompletableFutureFail() {
        CompletableFuture<String> ret = new CompletableFuture<String>();
        ret.completeExceptionally(new TestException());
        return ret;
    }

    @GET
    @Path(value="async/uni/ok")
    public Uni<String> asyncUniOK() {
        return Uni.createFrom().item((Object)"UNI-OK");
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="async/uni/list")
    public Uni<List<Person>> asyncUniListJson() {
        Person person = new Person();
        person.setFirst("Bob");
        person.setLast("Builder");
        return Uni.createFrom().item(Arrays.asList(person));
    }

    @GET
    @Path(value="async/uni/fail")
    public Uni<String> asyncUniStageFail() {
        return Uni.createFrom().failure((Throwable)new TestException());
    }

    @GET
    @Path(value="pre-match")
    public String preMatchGet() {
        return "pre-match-get";
    }

    @POST
    @Path(value="pre-match")
    public String preMatchPost() {
        return "pre-match-post";
    }

    @GET
    @Path(value="request-response-params")
    public String requestAndResponseParams(@Context HttpServerRequest request, @Context HttpServerResponse response) {
        response.headers().add("dummy", "value");
        return request.remoteAddress().host();
    }

    @GET
    @Path(value="jax-rs-request")
    public String jaxRsRequest(@Context Request request) {
        return request.getMethod();
    }

    @GET
    @Path(value="resource-info")
    public Response resourceInfo(@Context ResourceInfo resourceInfo, @Context HttpHeaders headers) {
        return Response.ok().header("class-name", (Object)resourceInfo.getResourceClass().getSimpleName()).header("method-name", (Object)headers.getHeaderString("method-name")).build();
    }

    @Path(value="form-map")
    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public MultivaluedMap<String, String> map(MultivaluedMap<String, String> map) {
        return map;
    }

    @Path(value="jsonp-object")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String jsonpObject(JsonObject jsonbObject) {
        return jsonbObject.getString("k");
    }

    @Path(value="jsonp-array")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Integer jsonpArray(JsonArray jsonArray) {
        return jsonArray.size();
    }

    @Path(value="/bool")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public boolean bool(boolean bool) {
        return bool;
    }

    @Path(value="/trace")
    @TRACE
    public Response trace() {
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="simplifiedResourceInfo")
    @Produces(value={"text/plain"})
    public String simplifiedResourceInfo(@Context SimpleResourceInfo simplifiedResourceInfo) {
        return simplifiedResourceInfo.getResourceClass().getName() + "#" + simplifiedResourceInfo.getMethodName() + "-" + simplifiedResourceInfo.parameterTypes().length;
    }

    @GET
    @Path(value="bigDecimal/{val}")
    @Produces(value={"text/plain"})
    public String bigDecimalConverter(BigDecimal val) {
        return val.toString();
    }

    private String collectionToString(Collection list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

