/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import io.quarkus.resteasy.reactive.server.test.simple.Bar;
import io.quarkus.resteasy.reactive.server.test.simple.BeanParamSubClass;
import io.quarkus.resteasy.reactive.server.test.simple.BeanParamSuperClass;
import io.quarkus.resteasy.reactive.server.test.simple.DynamicFeatureRequestFilterWithLowPriority;
import io.quarkus.resteasy.reactive.server.test.simple.FeatureMappedException;
import io.quarkus.resteasy.reactive.server.test.simple.FeatureMappedExceptionMapper;
import io.quarkus.resteasy.reactive.server.test.simple.FeatureRequestFilterWithHighestPriority;
import io.quarkus.resteasy.reactive.server.test.simple.FeatureRequestFilterWithNormalPriority;
import io.quarkus.resteasy.reactive.server.test.simple.FeatureResponseFilter;
import io.quarkus.resteasy.reactive.server.test.simple.FieldInjectedResource;
import io.quarkus.resteasy.reactive.server.test.simple.FieldInjectedSubClassResource;
import io.quarkus.resteasy.reactive.server.test.simple.Foo;
import io.quarkus.resteasy.reactive.server.test.simple.HeaderParamResource;
import io.quarkus.resteasy.reactive.server.test.simple.HelloService;
import io.quarkus.resteasy.reactive.server.test.simple.IllegalClassExceptionMapper;
import io.quarkus.resteasy.reactive.server.test.simple.InterfaceResource;
import io.quarkus.resteasy.reactive.server.test.simple.InterfaceResourceImpl;
import io.quarkus.resteasy.reactive.server.test.simple.MyParameter;
import io.quarkus.resteasy.reactive.server.test.simple.MyParameterConverter;
import io.quarkus.resteasy.reactive.server.test.simple.MyParameterProvider;
import io.quarkus.resteasy.reactive.server.test.simple.NewParamsRestResource;
import io.quarkus.resteasy.reactive.server.test.simple.OptionalQueryParamResource;
import io.quarkus.resteasy.reactive.server.test.simple.OtherBeanParam;
import io.quarkus.resteasy.reactive.server.test.simple.ParameterWithFromString;
import io.quarkus.resteasy.reactive.server.test.simple.Person;
import io.quarkus.resteasy.reactive.server.test.simple.QueryParamResource;
import io.quarkus.resteasy.reactive.server.test.simple.ResourceInfoInjectingFilter;
import io.quarkus.resteasy.reactive.server.test.simple.RootAResource;
import io.quarkus.resteasy.reactive.server.test.simple.RootBResource;
import io.quarkus.resteasy.reactive.server.test.simple.SimpleBeanParam;
import io.quarkus.resteasy.reactive.server.test.simple.SimpleQuarkusRestResource;
import io.quarkus.resteasy.reactive.server.test.simple.SubResource;
import io.quarkus.resteasy.reactive.server.test.simple.TRACE;
import io.quarkus.resteasy.reactive.server.test.simple.TestBarRequestFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestBarResponseFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestClass;
import io.quarkus.resteasy.reactive.server.test.simple.TestDynamicFeature;
import io.quarkus.resteasy.reactive.server.test.simple.TestException;
import io.quarkus.resteasy.reactive.server.test.simple.TestExceptionMapper;
import io.quarkus.resteasy.reactive.server.test.simple.TestFeature;
import io.quarkus.resteasy.reactive.server.test.simple.TestFooBarRequestFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestFooBarResponseFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestFooRequestFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestFooResponseFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestPreMatchRequestFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestRequestFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestRequestFilterWithHighPriority;
import io.quarkus.resteasy.reactive.server.test.simple.TestRequestFilterWithHighestPriority;
import io.quarkus.resteasy.reactive.server.test.simple.TestResponseFilter;
import io.quarkus.resteasy.reactive.server.test.simple.TestWriter;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SimpleQuarkusRestTestCase {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TRACE.class, SimpleQuarkusRestResource.class, Person.class, TestRequestFilter.class, TestRequestFilterWithHighPriority.class, TestRequestFilterWithHighestPriority.class, ResourceInfoInjectingFilter.class, Foo.class, Bar.class, TestFooRequestFilter.class, TestBarRequestFilter.class, TestFooBarRequestFilter.class, TestFooResponseFilter.class, TestBarResponseFilter.class, TestFooBarResponseFilter.class, TestResponseFilter.class, HelloService.class, TestException.class, TestExceptionMapper.class, TestPreMatchRequestFilter.class, FeatureMappedException.class, FeatureMappedExceptionMapper.class, FeatureRequestFilterWithNormalPriority.class, FeatureRequestFilterWithHighestPriority.class, FeatureResponseFilter.class, DynamicFeatureRequestFilterWithLowPriority.class, TestFeature.class, TestDynamicFeature.class, SubResource.class, RootAResource.class, RootBResource.class, QueryParamResource.class, HeaderParamResource.class, OptionalQueryParamResource.class, TestWriter.class, TestClass.class, SimpleBeanParam.class, OtherBeanParam.class, FieldInjectedResource.class, ParameterWithFromString.class, BeanParamSubClass.class, FieldInjectedSubClassResource.class, BeanParamSuperClass.class, IllegalClassExceptionMapper.class, MyParameterProvider.class, MyParameterConverter.class, MyParameter.class, NewParamsRestResource.class, InterfaceResource.class, InterfaceResourceImpl.class});
        }
    });

    @Test
    public void simpleTest() {
        ((ValidatableResponse)RestAssured.get((String)"/missing", (Object[])new Object[0]).then()).statusCode(404);
        ((ValidatableResponse)RestAssured.get((String)"/simple", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"GET"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/simple/foo", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"GET:foo"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.post((String)"/simple", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"POST"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.post((String)"/missing", (Object[])new Object[0]).then()).statusCode(404);
        ((ValidatableResponse)RestAssured.delete((String)"/missing", (Object[])new Object[0]).then()).statusCode(404);
        ((ValidatableResponse)RestAssured.delete((String)"/simple", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"DELETE"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.put((String)"/simple", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"PUT"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.head((String)"/simple", (Object[])new Object[0]).then()).header("Stef", "head");
        ((ValidatableResponse)RestAssured.options((String)"/simple", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OPTIONS"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.patch((String)"/simple", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"PATCH"), new Matcher[0]);
    }

    @Test
    public void test405() {
        ((ValidatableResponse)RestAssured.put((String)"/ctor-query", (Object[])new Object[0]).then()).statusCode(405);
        ((ValidatableResponse)RestAssured.put((String)"/simple/person", (Object[])new Object[0]).then()).statusCode(405);
    }

    @Test
    public void testInjection() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/hello", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hello"), new Matcher[0]);
    }

    @Test
    public void testSubResource() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/sub/otherSub", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"otherSub"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/simple/sub", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"sub"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().contentType(ContentType.JSON).body("{\"test\": true}").patch("/simple/sub/patch/text", new Object[0])).then()).statusCode(415);
    }

    @Test
    public void testParams() {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("q", new Object[]{"qv"}).header("h", (Object)"123", new Object[0]).formParam("f", new Object[]{"fv"}).post("/simple/params/pv", new Object[0])).then()).body(Matchers.equalTo((Object)"params: p: pv, q: qv, h: 123, f: fv"), new Matcher[0]);
    }

    @Test
    public void testBlocking() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/blocking", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"true"), new Matcher[0]);
    }

    @Test
    public void testPreMatchFilter() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/pre-match", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"pre-match-post"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.post((String)"/simple/pre-match", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"pre-match-post"), new Matcher[0]);
    }

    @Test
    public void testFilters() {
        Headers headers = ((ValidatableResponse)RestAssured.get((String)"/simple/fooFilters", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("filter-request")).containsOnly((Object[])new String[]{"authentication-authorization-foo-default"});
        Assertions.assertThat((List)headers.getValues("filter-response")).containsOnly((Object[])new String[]{"default-foo"});
        headers = ((ValidatableResponse)RestAssured.get((String)"/simple/filters", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("filter-request")).containsOnly((Object[])new String[]{"authentication-authorization-default"});
        Assertions.assertThat((List)headers.getValues("filter-response")).containsOnly((Object[])new String[]{"default"});
        headers = ((ValidatableResponse)RestAssured.get((String)"/simple/barFilters", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("filter-request")).containsOnly((Object[])new String[]{"authentication-authorization-default-bar"});
        Assertions.assertThat((List)headers.getValues("filter-response")).containsOnly((Object[])new String[]{"default-bar"});
        headers = ((ValidatableResponse)RestAssured.get((String)"/simple/fooBarFilters", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("filter-request")).containsOnly((Object[])new String[]{"authentication-authorization-foo-default-bar-foobar"});
        Assertions.assertThat((List)headers.getValues("filter-response")).containsOnly((Object[])new String[]{"default-foo-bar-foobar"});
    }

    @Test
    public void testProviders() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/providers", (Object[])new Object[0]).then()).body(Matchers.containsString((String)"TestException"), new Matcher[0])).statusCode(200);
    }

    @Test
    public void testException() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/mapped-exception", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0])).statusCode(666);
        ((ValidatableResponse)RestAssured.get((String)"/simple/unknown-exception", (Object[])new Object[0]).then()).statusCode(500);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/web-application-exception", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0])).statusCode(666);
    }

    @Test
    public void testWriter() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/lookup-writer", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/simple/writer", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"WRITER"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/simple/fast-writer", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/simple/writer/vertx-buffer", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"VERTX-BUFFER"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/simple/writer/mutiny-buffer", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"MUTINY-BUFFER"), new Matcher[0]);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testAsync() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/async/cs/ok", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"CS-OK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/async/cs/fail", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0])).statusCode(666);
        ((ValidatableResponse)RestAssured.get((String)"/simple/async/cf/ok", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"CF-OK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/async/cf/fail", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0])).statusCode(666);
        ((ValidatableResponse)RestAssured.get((String)"/simple/async/uni/ok", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"UNI-OK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/async/uni/fail", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0])).statusCode(666);
    }

    @Test
    public void testCompletableFutureBlocking() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/async/cf/blocking", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)Boolean.FALSE.toString()), new Matcher[0]);
    }

    @Test
    public void testMultiResourceSamePath() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/a", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"a"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/b", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"b"), new Matcher[0]);
    }

    @Test
    public void testRequestAndResponseParams() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/request-response-params", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"127.0.0.1"), new Matcher[0])).header("dummy", "value");
    }

    @Test
    public void testJaxRsRequest() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/jax-rs-request", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"GET"), new Matcher[0]);
    }

    @Test
    public void testFeature() {
        ((ValidatableResponse)RestAssured.get((String)"/simple/feature-mapped-exception", (Object[])new Object[0]).then()).statusCode(667);
        Headers headers = ((ValidatableResponse)RestAssured.get((String)"/simple/feature-filters", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("feature-filter-request")).containsOnly((Object[])new String[]{"authentication-default"});
        Assertions.assertThat((List)headers.getValues("feature-filter-response")).containsExactly((Object[])new String[]{"high-priority", "normal-priority"});
    }

    @Test
    public void testDynamicFeature() {
        Headers headers = ((ValidatableResponse)RestAssured.get((String)"/simple/dynamic-feature-filters", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("feature-filter-request")).containsOnly((Object[])new String[]{"authentication-default-low"});
        Assertions.assertThat((List)headers.getValues("feature-filter-response")).containsExactly((Object[])new String[]{"high-priority", "normal-priority", "low-priority"});
    }

    @Test
    public void testResourceInfo() {
        Headers headers = ((ValidatableResponse)RestAssured.get((String)"/simple/resource-info", (Object[])new Object[0]).then()).extract().headers();
        Assertions.assertThat((List)headers.getValues("class-name")).containsOnly((Object[])new String[]{"SimpleQuarkusRestResource"});
        Assertions.assertThat((List)headers.getValues("method-name")).containsOnly((Object[])new String[]{"resourceInfo"});
    }

    @Test
    public void testQueryParamInCtor() {
        ((ValidatableResponse)RestAssured.get((String)"/ctor-query", (Object[])new Object[0]).then()).body(Matchers.is((Matcher)Matchers.emptyString()), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/ctor-query?q1=v1", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"v1"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/ctor-query?q1=v11", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"v11"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/ctor-query?q2=v2", (Object[])new Object[0]).then()).body(Matchers.is((Matcher)Matchers.emptyString()), new Matcher[0]);
    }

    @Test
    public void testHeaderParamInCtor() {
        ((ValidatableResponse)RestAssured.get((String)"/ctor-header", (Object[])new Object[0]).then()).body(Matchers.is((Matcher)Matchers.emptyString()), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().header("h1", (Object)"v1", new Object[0]).get("/ctor-header", new Object[0])).then()).body(Matchers.equalTo((Object)"v1"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().header("h1", (Object)"v11", new Object[0]).get("/ctor-header", new Object[0])).then()).body(Matchers.equalTo((Object)"v11"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().header("h2", (Object)"v2", new Object[0]).get("/ctor-header", new Object[0])).then()).body(Matchers.is((Matcher)Matchers.emptyString()), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"rest-header-list", "rest-header-set", "rest-header-sorted-set"})
    public void testRestHeaderUsingCollection(String path) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("header", (Object)"a", new Object[]{"b"}).get("/simple/" + path, new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"a, b"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"header-param-list", "header-param-set", "header-param-sorted-set"})
    public void testHeaderParamUsingCollection(String path) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("header", (Object)"a", new Object[]{"b"}).get("/simple/" + path, new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"a, b"), new Matcher[0]);
    }

    @Test
    public void testFormMap() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Content-Type", (Object)"application/x-www-form-urlencoded", new Object[0]).header("Accept", (Object)"application/x-www-form-urlencoded", new Object[0]).formParam("f1", new Object[]{"v1"}).formParam("f2", new Object[]{"v2"}).post("/simple/form-map", new Object[0])).then()).statusCode(200)).contentType("application/x-www-form-urlencoded")).body(Matchers.equalTo((Object)"f1=v1&f2=v2"), new Matcher[0]);
    }

    @Test
    public void testJsonp() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().body("{\"k\": \"v\"}").contentType("application/json; charset=utf-8").post("/simple/jsonp-object", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"v"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().body("[{}, {}]").contentType("application/json").post("/simple/jsonp-array", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
    }

    @Test
    public void testPrimitiveBody() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().body("true").contentType("text/plain").post("/simple/bool", new Object[0])).then()).statusCode(200)).contentType("text/plain")).body(Matchers.equalTo((Object)"true"), new Matcher[0]);
    }

    @Test
    public void testCustomHttpMethodAnnotation() {
        ((ValidatableResponse)RestAssured.request((String)"TRACE", (String)"/simple/trace", (Object[])new Object[0]).then()).statusCode(200);
    }

    @Test
    public void simpleFieldInjection() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("header", (Object)"one-header", new Object[0]).queryParam("query", new Object[]{"one-query"}).queryParam("queryList", new Object[]{"one"}).queryParam("queryList", new Object[]{"two"}).queryParam("int", new Object[]{"666"}).get("/injection/field", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("header", (Object)"one-header", new Object[0]).queryParam("query", new Object[]{"one-query"}).queryParam("queryList", new Object[]{"one"}).queryParam("queryList", new Object[]{"two"}).queryParam("int", new Object[]{"666"}).get("/injection/param", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
    }

    @Test
    public void fieldInjectionWithSubClasses() {
        ((ValidatableResponse)((Response)RestAssured.with().header("header", (Object)"one-header", new Object[0]).queryParam("query", new Object[]{"one-query"}).queryParam("queryList", new Object[]{"one"}).queryParam("queryList", new Object[]{"two"}).queryParam("int", new Object[]{"666"}).get("/injection-subclass/field2", new Object[0])).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().header("header", (Object)"one-header", new Object[0]).queryParam("query", new Object[]{"one-query"}).queryParam("queryList", new Object[]{"one"}).queryParam("queryList", new Object[]{"two"}).queryParam("int", new Object[]{"666"}).get("/injection-subclass/param2", new Object[0])).then()).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testNewParams() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/new-params/myklass/myregex/context", (Object[])new Object[0]).then()).log().ifError()).statusCode(200)).body(Matchers.equalTo((Object)"OK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/new-params/myklass/myregex/mymethod", (Object[])new Object[0]).then()).log().ifError()).body(Matchers.equalTo((Object)"GET:myklass:myregex:mymethod"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().urlEncodingEnabled(false).cookie("c", (Object)"cv", new Object[0]).queryParam("q", new Object[]{"qv"}).queryParam("q3", new Object[]{"999"}).header("h", (Object)"123", new Object[0]).header("X-My-Header", (Object)"test", new Object[0]).header("Test-Header-Param", (Object)"test", new Object[0]).header("Param-Empty", (Object)"empty", new Object[0]).formParam("f", new Object[]{"fv"}).post("/new-params/myklass;m=mv/myregex/params/pv", new Object[0])).then()).log().ifError()).body(Matchers.equalTo((Object)"params: p: pv, q: qv, h: 123, xMyHeader: test, testHeaderParam: test, paramEmpty: empty, f: fv, m: mv, c: cv, q2: empty, q3: 999"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/new-params/myklass/myregex/sse", (Object[])new Object[0]).then()).log().ifError()).body(Matchers.equalTo((Object)"data:OK\n\n"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().urlEncodingEnabled(false).formParam("f", new Object[]{"fv"}).post("/new-params/myklass;m=mv/myregex/form-blocking", new Object[0])).then()).body(Matchers.equalTo((Object)"fv"), new Matcher[0]);
    }

    @Test
    public void simplifiedResourceInfo() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/simplifiedResourceInfo", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsString((String)"SimpleQuarkusRestResource#simplifiedResourceInfo-1"), new Matcher[0]);
    }

    @Test
    public void bigDecimal() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/simple/bigDecimal/1.0", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"1.0"), new Matcher[0]);
    }

    @Test
    public void testInterfaceResource() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/iface", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"Hello"), new Matcher[0]);
    }

    @Test
    public void testQueryParamWithOptionalSingleValue() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello nobody", (Object)RestAssured.get((String)"/optional-query/greetings/one", (Object[])new Object[0]).asString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello albert", (Object)((Response)RestAssured.given().queryParam("name", new Object[]{"albert"}).get("/optional-query/greetings/one", new Object[0])).asString());
    }

    @Test
    public void testQueryParamWithOptionalList() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello nobody", (Object)RestAssured.get((String)"/optional-query/greetings/list", (Object[])new Object[0]).asString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello albert and jose", (Object)((Response)RestAssured.given().queryParam("name", new Object[]{"albert", "jose"}).get("/optional-query/greetings/list", new Object[0])).asString());
    }

    @Test
    public void testQueryParamWithOptionalSet() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello nobody", (Object)RestAssured.get((String)"/optional-query/greetings/set", (Object[])new Object[0]).asString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello albert and jose", (Object)((Response)RestAssured.given().queryParam("name", new Object[]{"albert", "jose"}).get("/optional-query/greetings/set", new Object[0])).asString());
    }

    @Test
    public void testQueryParamWithOptionalSortedSet() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello nobody", (Object)RestAssured.get((String)"/optional-query/greetings/sortedset", (Object[])new Object[0]).asString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello albert and jose", (Object)((Response)RestAssured.given().queryParam("name", new Object[]{"albert", "jose"}).get("/optional-query/greetings/sortedset", new Object[0])).asString());
    }
}

