/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.simple;

import jakarta.ws.rs.core.Application;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

public class TestUtil {
    protected static Logger LOG;
    private static String baseResourcePath;

    public static WebArchive prepareArchiveWithApplication(String deploymentName, Class<? extends Application> clazz) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(deploymentName + ".war"));
        war.addClass(clazz);
        return war;
    }

    public static Archive<?> finishContainerPrepare(WebArchive war, Map<String, String> contextParams, Class<?> ... resources) {
        return TestUtil.finishContainerPrepare(war, contextParams, null, resources);
    }

    public static Archive<?> finishContainerPrepare(WebArchive war, Map<String, String> contextParams, List<Class<?>> singletons, Class<?> ... resources) {
        if (contextParams == null) {
            contextParams = new Hashtable<String, String>();
        }
        HashSet<String> classNamesInDeployment = new HashSet<String>();
        HashSet<String> singletonsNamesInDeployment = new HashSet<String>();
        if (resources != null) {
            for (Class<?> clazz : resources) {
                war.addClass((Class)clazz);
                classNamesInDeployment.add(clazz.getTypeName());
            }
        }
        if (singletons != null) {
            for (Class clazz : singletons) {
                war.addClass(clazz);
                singletonsNamesInDeployment.add(clazz.getTypeName());
            }
        }
        if (contextParams != null && contextParams.size() > 0 && !war.contains("WEB-INF/web.xml")) {
            StringBuilder webXml = new StringBuilder();
            webXml.append("<web-app version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\" \n");
            webXml.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
            webXml.append(" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"> \n");
            for (Map.Entry<String, String> entry : contextParams.entrySet()) {
                String string = entry.getKey();
                String paramValue = entry.getValue();
                LOG.debug((Object)("Context param " + string + " value " + paramValue));
                webXml.append("<context-param>\n");
                webXml.append("<param-name>" + string + "</param-name>\n");
                webXml.append("<param-value>" + paramValue + "</param-value>\n");
                webXml.append("</context-param>\n");
            }
            webXml.append("</web-app>\n");
            StringAsset stringAsset = new StringAsset(webXml.toString());
            war.addAsWebInfResource((Asset)stringAsset, "web.xml");
        }
        StringBuilder classes = new StringBuilder();
        boolean bl = true;
        for (String string : classNamesInDeployment) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                classes.append(",");
            }
            classes.append(string);
        }
        war.addAsResource((Asset)new StringAsset(classes.toString()), "classes.txt");
        StringBuilder singletonBuilder = new StringBuilder();
        boolean bl3 = true;
        for (String clazz : singletonsNamesInDeployment) {
            boolean bl4;
            if (bl4) {
                bl4 = false;
            } else {
                singletonBuilder.append(",");
            }
            singletonBuilder.append(clazz);
        }
        war.addAsResource((Asset)new StringAsset(singletonBuilder.toString()), "singletons.txt");
        if (System.getProperty("STORE_WAR") != null) {
            ((ZipExporter)war.as(ZipExporter.class)).exportTo(new File("target", war.getName()), true);
        }
        return war;
    }

    protected WebArchive addPackageInfo(WebArchive war, Class<?> clazz) {
        return (WebArchive)war.addPackages(false, (Filter)new Filter<ArchivePath>(){

            public boolean include(ArchivePath path) {
                return path.get().endsWith("package-info.class");
            }
        }, new Package[]{clazz.getPackage()});
    }

    public static String readString(InputStream in) throws IOException {
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 1024)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public static String getErrorMessageForKnownIssue(String jira, String message) {
        StringBuilder s = new StringBuilder();
        s.append("https://issues.jboss.org/browse/");
        s.append(jira);
        s.append(" - ");
        s.append(message);
        return s.toString();
    }

    public static String getErrorMessageForKnownIssue(String jira) {
        return TestUtil.getErrorMessageForKnownIssue(jira, "known issue");
    }

    public static String getJbossHome() {
        return System.getProperty("jboss.home");
    }

    public static String getJbossHome(boolean onServer) {
        if (!onServer) {
            return TestUtil.getJbossHome();
        }
        return System.getProperty("jboss.home.dir", "");
    }

    public static String getStandaloneDir(String containerQualifier) {
        return TestUtil.getStandaloneDir(false, containerQualifier);
    }

    public static String getStandaloneDir(boolean onServer, String containerQualifier) {
        if (!onServer) {
            if (containerQualifier == null) {
                return new File(TestUtil.getJbossHome(), "standalone").getAbsolutePath();
            }
            return new File("target", containerQualifier).getAbsolutePath();
        }
        return System.getProperty("jboss.server.base.dir", "");
    }

    public static boolean isOpenJDK() {
        return System.getProperty("java.runtime.name").toLowerCase().contains("openjdk");
    }

    public static boolean isWildFly9x() {
        String sv = System.getProperty("server.version");
        return "9.0.2.Final".equals(sv) || "9.0.1.Final".equals(sv) || "9.0.0.Final".equals(sv);
    }

    public static boolean isOracleJDK() {
        if (TestUtil.isOpenJDK()) {
            return false;
        }
        String vendor = System.getProperty("java.vendor").toLowerCase();
        return vendor.contains("sun") || vendor.contains("oracle");
    }

    public static boolean isIbmJdk() {
        return System.getProperty("java.vendor").toLowerCase().contains("ibm");
    }

    public static String getResourcePath(Class<?> c, String name) {
        return baseResourcePath + c.getPackage().getName().replace('.', File.separatorChar) + File.separator + name;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assertions.fail((String)"Can't get the operating system name");
        }
        return osName.indexOf("Windows") > -1 || osName.indexOf("windows") > -1;
    }

    static {
        baseResourcePath = "src" + File.separator + "test" + File.separator + "resources" + File.separator;
        try {
            LOG = Logger.getLogger((String)TestUtil.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

