/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.status;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.reactive.ResponseStatus;
import org.jboss.resteasy.reactive.RestMulti;
import org.jboss.resteasy.reactive.RestQuery;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ResponseStatusTest {
    @RegisterExtension
    static QuarkusUnitTest TEST = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{TestResource.class}));

    @Test
    public void testReturnUni() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/uni", new Object[0])).then()).statusCode(201);
    }

    @Test
    public void testReturnMulti() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/multi", new Object[0])).then()).statusCode(202);
    }

    @Test
    public void testReturnCompletionStage() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/completion", new Object[0])).then()).statusCode(203);
    }

    @Test
    public void testReturnString() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/plain", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testUniThrowsException() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_uni", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void testMultiThrowsException() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_multi", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void testCompletionStageThrowsException() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_completion", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void testStringThrowsException() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_plain", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void testReturnRestMulti() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi", new Object[0])).then()).statusCode(210);
    }

    @Test
    public void testReturnRestMulti2() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi2", new Object[0])).then()).statusCode(211);
    }

    @Test
    public void testReturnRestMulti3() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi3", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi3?status=212", new Object[0])).then()).statusCode(212);
    }

    @Test
    public void testReturnRestMulti4() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi4", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi4", new Object[0])).then()).statusCode(200);
    }

    @Path(value="/test")
    public static class TestResource {
        private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];

        @ResponseStatus(value=201)
        @GET
        @Path(value="/uni")
        public Uni<String> getTestUni() {
            return Uni.createFrom().item((Object)"test");
        }

        @ResponseStatus(value=202)
        @GET
        @Path(value="/multi")
        public Multi<String> getTestMulti() {
            return Multi.createFrom().item((Object)"test");
        }

        @ResponseStatus(value=203)
        @GET
        @Path(value="/completion")
        public CompletionStage<String> getTestCompletion() {
            return CompletableFuture.supplyAsync(() -> "test");
        }

        @ResponseStatus(value=204)
        @GET
        @Path(value="/plain")
        public String getTestPlain() {
            return "test";
        }

        @ResponseStatus(value=201)
        @GET
        @Path(value="/exception_uni")
        public Uni<String> throwExceptionUni() {
            return Uni.createFrom().failure((Throwable)this.createException());
        }

        @ResponseStatus(value=201)
        @GET
        @Path(value="/exception_multi")
        public Multi<String> throwExceptionMulti() {
            return Multi.createFrom().failure((Throwable)this.createException());
        }

        @ResponseStatus(value=201)
        @GET
        @Path(value="/exception_completion")
        public CompletionStage<String> throwExceptionCompletion() {
            return CompletableFuture.failedFuture(this.createException());
        }

        @ResponseStatus(value=201)
        @GET
        @Path(value="/exception_plain")
        public String throwExceptionPlain() {
            throw this.createException();
        }

        @ResponseStatus(value=202)
        @GET
        @Path(value="/rest-multi")
        public RestMulti<String> getTestRestMulti() {
            return RestMulti.fromMultiData((Multi)Multi.createFrom().item((Object)"test")).status(210).build();
        }

        @GET
        @Path(value="/rest-multi2")
        public RestMulti<String> getTestRestMulti2() {
            return RestMulti.fromMultiData((Multi)Multi.createFrom().item((Object)"test")).status(211).build();
        }

        @GET
        @Path(value="/rest-multi3")
        public RestMulti<String> getTestRestMulti3(@DefaultValue(value="200") @RestQuery Integer status) {
            return RestMulti.fromUniResponse((Uni)Uni.createFrom().item((Object)"unused"), s -> Multi.createFrom().item((Object)"test"), null, s -> status);
        }

        @GET
        @Path(value="/rest-multi4")
        public RestMulti<String> getTestRestMulti4() {
            return RestMulti.fromUniResponse((Uni)Uni.createFrom().item((Object)"unused"), s -> Multi.createFrom().item((Object)"test"));
        }

        private IllegalArgumentException createException() {
            IllegalArgumentException result = new IllegalArgumentException();
            result.setStackTrace(EMPTY_STACK_TRACE);
            return result;
        }
    }
}

