/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.stream;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.vertx.core.buffer.Buffer;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.Sse;
import java.util.Date;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.jboss.resteasy.reactive.common.util.MultiCollectors;
import org.reactivestreams.Publisher;

@Path(value="stream")
public class StreamResource {
    private static final int INITIAL_BUFFER_SIZE = 2048;
    private boolean receivedCancel = false;

    @Path(value="text/collect")
    @GET
    @Produces(value={"text/plain"})
    public Uni<String> getCollectedText() {
        return MultiCollectors.concatenateStrings(this.getStreamedText());
    }

    @Path(value="text/stream")
    @GET
    @Produces(value={"text/plain"})
    public Multi<String> getStreamedText() {
        return Multi.createFrom().items((Object[])new String[]{"foo", "bar"});
    }

    @Path(value="text/stream/publisher")
    @GET
    @Produces(value={"text/plain"})
    public Flow.Publisher<String> getStreamedTextPublisher() {
        return Multi.createFrom().items((Object[])new String[]{"foo", "bar"});
    }

    @Path(value="text/stream/legacy-publisher")
    @GET
    @Produces(value={"text/plain"})
    public Publisher<String> getStreamedTextLegacyPublisher() {
        return AdaptersToReactiveStreams.publisher((Flow.Publisher)Multi.createFrom().items((Object[])new String[]{"foo", "bar"}));
    }

    @Path(value="byte-arrays/collect")
    @GET
    @Produces(value={"text/plain"})
    public Uni<byte[]> getCollectedByteArrays() {
        return MultiCollectors.concatenateByteArrays(this.getStreamedByteArrays());
    }

    @Path(value="byte-arrays/stream")
    @GET
    @Produces(value={"text/plain"})
    public Multi<byte[]> getStreamedByteArrays() {
        return Multi.createFrom().items((Object[])new byte[][]{"foo".getBytes(), "bar".getBytes()});
    }

    @Path(value="char-arrays/collect")
    @GET
    @Produces(value={"text/plain"})
    public Uni<char[]> getCollectedCharacterArrays() {
        return MultiCollectors.concatenateCharArrays(this.getStreamedCharArrays());
    }

    @Path(value="char-arrays/stream")
    @GET
    @Produces(value={"text/plain"})
    public Multi<char[]> getStreamedCharArrays() {
        return Multi.createFrom().items((Object[])new char[][]{"foo".toCharArray(), "bar".toCharArray()});
    }

    @Path(value="char-arrays/stream/publisher")
    @GET
    @Produces(value={"text/plain"})
    public Flow.Publisher<char[]> getStreamedCharArraysPublisher() {
        return Multi.createFrom().items((Object[])new char[][]{"foo".toCharArray(), "bar".toCharArray()});
    }

    @Path(value="buffer/collect")
    @GET
    @Produces(value={"text/plain"})
    public Uni<Buffer> getCollectedBuffers() {
        return StreamResource.concatenateBuffers(this.getStreamedBuffers());
    }

    @Path(value="buffer/stream")
    @GET
    @Produces(value={"text/plain"})
    public Multi<Buffer> getStreamedBuffers() {
        return Multi.createFrom().items((Object[])new Buffer[]{Buffer.buffer((String)"foo"), Buffer.buffer((String)"bar")});
    }

    public static Uni<Buffer> concatenateBuffers(Multi<Buffer> multi) {
        return multi.collect().in(() -> Buffer.buffer((int)2048), (accumulatingBuffer, receivedBuffer) -> accumulatingBuffer.appendBuffer(receivedBuffer));
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="infinite/stream")
    public Multi<String> infiniteStream() {
        this.receivedCancel = false;
        return Multi.createFrom().emitter(emitter -> {
            ScheduledExecutorService scheduler = Infrastructure.getDefaultWorkerPool();
            ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(() -> {
                String str = "Called at " + new Date();
                emitter.emit((Object)str);
            }, 0L, 1L, TimeUnit.SECONDS);
            emitter.onTermination(() -> {
                if (emitter.isCancelled()) {
                    this.receivedCancel = true;
                    if (!future.isCancelled()) {
                        future.cancel(true);
                    }
                }
            });
            scheduler.schedule(() -> {
                if (!future.isCancelled()) {
                    future.cancel(true);
                    emitter.complete();
                }
            }, 30L, TimeUnit.SECONDS);
        });
    }

    @GET
    @Path(value="infinite/stream-was-cancelled")
    public String infiniteStreamWasCancelled() {
        return this.receivedCancel ? "OK" : "KO";
    }

    @Path(value="sse")
    @GET
    @Produces(value={"text/event-stream"})
    public Multi<String> sse() {
        return Multi.createFrom().items((Object[])new String[]{"a", "b", "c"});
    }

    @Path(value="sse/throw")
    @GET
    @Produces(value={"text/event-stream"})
    public Multi<String> sseThrows() {
        throw new IllegalStateException("STOP");
    }

    @Path(value="sse/raw")
    @GET
    @Produces(value={"text/event-stream"})
    public Multi<OutboundSseEvent> sseRaw(@Context Sse sse) {
        return Multi.createFrom().items((Object[])new OutboundSseEvent[]{sse.newEventBuilder().comment("dummy").build(), sse.newEventBuilder().id("one").data((Object)"uno").name("eins").build(), sse.newEventBuilder().id("two").data((Object)"dos").name("zwei").build(), sse.newEventBuilder().id("three").data((Object)"tres").name("drei").build()});
    }
}

