/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CancelableCompletionStageTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{Resource.class}));
    @Inject
    Vertx vertx;
    @TestHTTPResource
    URL url;

    @BeforeEach
    void setUp() {
        Resource.COUNT.set(0);
    }

    @Test
    public void testNormal() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("test", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello, world"), new Matcher[0]);
    }

    @Test
    public void testCancel() {
        WebClient client = WebClient.create((Vertx)this.vertx);
        client.get(this.url.getPort(), this.url.getHost(), "/test").send();
        try {
            Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAtomic(Resource.COUNT, CoreMatchers.equalTo((Object)1));
            client.close();
            Thread.sleep(7000L);
            Assertions.assertEquals((int)1, (int)Resource.COUNT.get());
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                client.close();
            }
            catch (Exception exception) {}
        }
    }

    @Path(value="test")
    public static class Resource {
        public static final AtomicInteger COUNT = new AtomicInteger(0);

        @GET
        @Produces(value={"text/plain"})
        public CompletionStage<String> hello() {
            COUNT.incrementAndGet();
            return CompletableFuture.supplyAsync(new Supplier<String>(){

                @Override
                public String get() {
                    COUNT.incrementAndGet();
                    return "Hello, world";
                }
            }, CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS));
        }
    }
}

