/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CancelableUniTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{Resource.class}));
    @Inject
    Vertx vertx;
    @TestHTTPResource
    URL url;

    @BeforeEach
    void setUp() {
        Resource.COUNT.set(0);
    }

    @Test
    public void testNormal() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("test", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Hello, world"), new Matcher[0]);
    }

    @Test
    public void testCancel() {
        WebClient client = WebClient.create((Vertx)this.vertx);
        client.get(this.url.getPort(), this.url.getHost(), "/test").send();
        try {
            Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAtomic(Resource.COUNT, CoreMatchers.equalTo((Object)1));
            client.close();
            Thread.sleep(7000L);
            Assertions.assertEquals((int)1, (int)Resource.COUNT.get());
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                client.close();
            }
            catch (Exception exception) {}
        }
    }

    @Path(value="test")
    public static class Resource {
        public static final AtomicInteger COUNT = new AtomicInteger(0);

        @GET
        @Produces(value={"text/plain"})
        public Uni<String> hello() {
            COUNT.incrementAndGet();
            return Uni.createFrom().item((Object)"Hello, world").onItem().delayIt().by(Duration.ofSeconds(5L)).onItem().invoke(COUNT::incrementAndGet);
        }
    }
}

