/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.NonBlockingReturnTypeBuildItem;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.common.annotation.Blocking;
import jakarta.enterprise.context.Dependent;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.jandex.DotName;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CustomNonBlockingReturnTypeTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class, CustomType.class, CustomType2.class, HasMessageMessageBodyWriter.class});
        }
    }).addBuildChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

        @Override
        public void accept(BuildChainBuilder buildChainBuilder) {
            buildChainBuilder.addBuildStep(new BuildStep(){

                public void execute(BuildContext context) {
                    context.produce((BuildItem)new NonBlockingReturnTypeBuildItem(DotName.createSimple((String)CustomType.class.getName())));
                }
            }).produces(NonBlockingReturnTypeBuildItem.class).build();
        }
    });

    @Test
    public void testNoAnnotation() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/noAnnotation", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"blocking allowed: false"), new Matcher[0]);
    }

    @Test
    public void testOtherNoAnnotation() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/otherNoAnnotation", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"blocking allowed: true"), new Matcher[0]);
    }

    @Test
    public void testWithBlockingAnnotation() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/withBlockingAnnotation", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"blocking allowed: true"), new Matcher[0]);
    }

    @Provider
    @Dependent
    public static class HasMessageMessageBodyWriter<T extends HasMessage>
    implements ServerMessageBodyWriter<T> {
        public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
            return HasMessage.class.isAssignableFrom(type);
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return HasMessage.class.isAssignableFrom(type);
        }

        public void writeResponse(T o, Type genericType, ServerRequestContext context) throws WebApplicationException {
            context.serverResponse().end(o.getMessage());
        }

        public void writeTo(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(o.getMessage().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static interface HasMessage {
        public String getMessage();
    }

    public static class CustomType2
    implements HasMessage {
        private final String message;

        public CustomType2(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class CustomType
    implements HasMessage {
        private final String message;

        public CustomType(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    @Path(value="test")
    public static class Resource {
        @Path(value="noAnnotation")
        @GET
        public CustomType noAnnotation() {
            return new CustomType("blocking allowed: " + BlockingOperationControl.isBlockingAllowed());
        }

        @Path(value="otherNoAnnotation")
        @GET
        public CustomType2 otherNoAnnotation() {
            return new CustomType2("blocking allowed: " + BlockingOperationControl.isBlockingAllowed());
        }

        @Path(value="withBlockingAnnotation")
        @GET
        @Blocking
        public CustomType withBlockingAnnotation() {
            return new CustomType("blocking allowed: " + BlockingOperationControl.isBlockingAllowed());
        }
    }
}

