/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MutinyAsCompletionStageTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(TestResource.class);
        }
    });

    @Test
    public void testOk() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/ok", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"test"), new Matcher[0]);
    }

    @Test
    public void testError() {
        ((ValidatableResponse)RestAssured.get((String)"/test/error", (Object[])new Object[0]).then()).statusCode(400);
    }

    @Path(value="test")
    public static class TestResource {
        @GET
        @Produces(value={"text/plain"})
        @Path(value="/ok")
        public CompletionStage<String> ok() {
            return Uni.createFrom().item((Object)"test").subscribeAsCompletionStage();
        }

        @GET
        @Produces(value={"text/plain"})
        @Path(value="/error")
        public CompletionStage<String> error() {
            return Uni.createFrom().failure((Throwable)new BadRequestException()).subscribeAsCompletionStage();
        }
    }
}

