/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.PreExceptionMapperHandlerBuildItem;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class PreExceptionMapperHandlerTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class, Mappers.class, DummyPreExceptionMapperHandler.class});
        }
    }).addBuildChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

        @Override
        public void accept(BuildChainBuilder buildChainBuilder) {
            buildChainBuilder.addBuildStep(new BuildStep(){

                public void execute(BuildContext context) {
                    context.produce((BuildItem)new PreExceptionMapperHandlerBuildItem((ServerRestHandler)new DummyPreExceptionMapperHandler()));
                }
            }).produces(PreExceptionMapperHandlerBuildItem.class).build();
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test", (Object[])new Object[0]).then()).statusCode(999)).header("foo", "bar");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/uni", (Object[])new Object[0]).then()).statusCode(999)).header("foo", "bar");
    }

    public static class DummyPreExceptionMapperHandler
    implements ServerRestHandler {
        public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
            Assertions.assertThat((Throwable)requestContext.getThrowable()).isInstanceOf(RuntimeException.class);
            requestContext.setProperty("foo", (Object)"bar");
        }
    }

    public static class Mappers {
        @ServerExceptionMapper(value={RuntimeException.class})
        Response handle(ResteasyReactiveContainerRequestContext requestContext) {
            return Response.status((int)999).header("foo", requestContext.getProperty("foo")).build();
        }
    }

    @Path(value="test")
    public static class Resource {
        @GET
        public String get() {
            throw new RuntimeException("dummy");
        }

        @Path(value="uni")
        @GET
        public Uni<String> uniGet() {
            return Uni.createFrom().item(() -> {
                throw new RuntimeException("dummy");
            });
        }
    }
}

