/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RequestLeakDetectionTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{MyRestAPI.class, MyRequestScopeBean.class, Barrier.class, Task.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml"));
    @Inject
    Barrier barrier;

    @Test
    public void testWithConcurrentCalls() {
        CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        int count = 100;
        this.barrier.setMaxConcurrency(count);
        int i = 0;
        while (i < count) {
            int c = i++;
            new Thread(() -> {
                ResponseBody body = ((Response)((Response)RestAssured.given().pathParam("val", (Object)c).contentType("application/json").get("/test/{val}", new Object[0])).thenReturn()).body();
                String value = body.toString();
                results.add(value);
            }).start();
        }
        Awaitility.await().until(() -> results.size() == count);
        HashSet asSet = new HashSet(results);
        Assertions.assertEquals((int)asSet.size(), (int)count);
    }

    @Test
    public void testWithConcurrentBlockingCalls() {
        CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        int count = 100;
        this.barrier.setMaxConcurrency(count);
        int i = 0;
        while (i < count) {
            int c = i++;
            new Thread(() -> {
                ResponseBody body = ((Response)((Response)RestAssured.given().pathParam("val", (Object)c).contentType("application/json").get("/test/blocking/{val}", new Object[0])).thenReturn()).body();
                String value = body.toString();
                results.add(value);
            }).start();
        }
        Awaitility.await().until(() -> results.size() == count);
        HashSet asSet = new HashSet(results);
        Assertions.assertEquals((int)asSet.size(), (int)count);
    }

    @ApplicationScoped
    public static class Barrier {
        private int level;
        private final AtomicInteger counter = new AtomicInteger();
        private final List<Task> tasks = new CopyOnWriteArrayList<Task>();

        public void setMaxConcurrency(int level) {
            this.level = level;
        }

        public void enqueue(Context context, Runnable runnable) {
            Task task = new Task(context, runnable);
            this.tasks.add(task);
            if (this.counter.incrementAndGet() >= this.level) {
                for (Task tbr : new ArrayList<Task>(this.tasks)) {
                    tbr.run();
                    this.tasks.remove(tbr);
                }
            }
        }
    }

    @ApplicationScoped
    @Path(value="/test")
    public static class MyRestAPI {
        @Inject
        MyRequestScopeBean bean;
        @Inject
        Barrier barrier;

        @GET
        @Path(value="/{val}")
        public Uni<Foo> foo(int val) {
            Assertions.assertTrue((boolean)VertxContext.isOnDuplicatedContext());
            Vertx.currentContext().putLocal((Object)"count", (Object)val);
            this.bean.setValue(val);
            return Uni.createFrom().emitter(e -> this.barrier.enqueue(Vertx.currentContext(), () -> {
                Assertions.assertTrue((boolean)VertxContext.isOnDuplicatedContext());
                int r = (Integer)Vertx.currentContext().getLocal((Object)"count");
                Assertions.assertEquals((int)r, (int)val);
                e.complete((Object)this.bean.getValue());
            })).map(i -> new Foo(Integer.toString(i)));
        }

        @GET
        @Path(value="/blocking/{val}")
        public Foo blocking(int val) {
            Assertions.assertTrue((boolean)VertxContext.isOnDuplicatedContext());
            Vertx.currentContext().putLocal((Object)"count", (Object)val);
            this.bean.setValue(val);
            return (Foo)Uni.createFrom().emitter(e -> this.barrier.enqueue(Vertx.currentContext(), () -> {
                Assertions.assertTrue((boolean)VertxContext.isOnDuplicatedContext());
                int r = (Integer)Vertx.currentContext().getLocal((Object)"count");
                Assertions.assertEquals((int)r, (int)val);
                e.complete((Object)this.bean.getValue());
            })).map(i -> new Foo(Integer.toString(i))).await().indefinitely();
        }
    }

    @RequestScoped
    public static class MyRequestScopeBean {
        private int value = -1;

        public void setValue(int v) {
            if (this.value != -1) {
                throw new IllegalStateException("Already initialized");
            }
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class Task {
        private final Context context;
        private final Runnable runnable;

        private Task(Context context, Runnable runnable) {
            this.context = context;
            this.runnable = runnable;
        }

        void run() {
            this.context.runOnContext(x -> this.runnable.run());
        }
    }

    public static class Foo {
        public final String value;

        public Foo(String value) {
            this.value = value;
        }
    }
}

