/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RequestScopedParamConverterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestResource.class, Model.class});
        }
    });

    @Test
    public void testNoAnnotation() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("foo", (Object)"bar", new Object[0]).when().get("/test/test", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"test/bar"), new Matcher[0]);
    }

    public static class Model {
        public final String value;
        public final String fooHeader;

        public Model(String value, String fooHeader) {
            this.value = value;
            this.fooHeader = fooHeader;
        }

        public static Model valueOf(String value) {
            return new Model(value, (String)CurrentRequestManager.get().getHeader("foo", true));
        }
    }

    @Path(value="test")
    public static class TestResource {
        @GET
        @Path(value="{value}")
        @Produces(value={"text/plain"})
        public String hello(@PathParam(value="value") Model model) {
            return model.value + "/" + model.fooHeader;
        }
    }
}

