/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.ResumeOn404BuildItem;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.vertx.ext.web.Router;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ResumeOn404BuildItemTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class, CustomRoute.class});
        }
    }).addBuildChainCustomizer(ResumeOn404BuildItemTest.buildCustomizer());

    protected static Consumer<BuildChainBuilder> buildCustomizer() {
        return new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder builder) {
                builder.addBuildStep(context -> context.produce((BuildItem)new ResumeOn404BuildItem())).produces(ResumeOn404BuildItem.class).build();
            }
        };
    }

    @Test
    public void matchingFromResteasyReactive() {
        ((ValidatableResponse)RestAssured.get((String)"/test", (Object[])new Object[0]).then()).statusCode(200);
    }

    @Test
    public void matchingFromCustomRoute() {
        ((ValidatableResponse)RestAssured.get((String)"/main", (Object[])new Object[0]).then()).statusCode(200);
    }

    @Test
    public void missing() {
        ((ValidatableResponse)RestAssured.get((String)"/dummy", (Object[])new Object[0]).then()).statusCode(404);
    }

    public static class CustomRoute {
        public void initMain(@Observes Router router) {
            router.get("/main").handler(rc -> rc.response().end("main"));
        }
    }

    @Path(value="/test")
    @RequestScoped
    public static class Resource {
        @GET
        @Produces(value={"text/plain"})
        public String hello() {
            return "test";
        }
    }
}

