/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResource;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class StringTestHTTPResourceWithPathParamsTest {
    @RegisterExtension
    static final QuarkusUnitTest test = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClass(UserResource.class));
    @TestHTTPEndpoint(value=UserResource.class)
    @TestHTTPResource(value="{userId}/order/{orderId}")
    String getUserOrderUrl;

    @Test
    void testGettingUserOrder() {
        int userId = 123;
        int orderId = 456;
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get(this.getUserOrderUrl, new Object[]{userId, orderId})).then()).statusCode(200)).body(Matchers.equalTo((Object)String.format("Order (%d) of user (%d)", userId, orderId)), new Matcher[0]);
    }

    @Path(value="/user")
    public static class UserResource {
        @Path(value="{userId}/order/{orderId}")
        @GET
        @Produces(value={"text/plain"})
        public String getUserOrder(@PathParam(value="userId") int userId, @PathParam(value="orderId") int orderId) {
            return String.format("Order (%d) of user (%d)", userId, orderId);
        }
    }
}

