/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.SubResourcesAsBeansBuildItem;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestPath;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SubResourcesAsBeansTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().addBuildChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

        @Override
        public void accept(BuildChainBuilder buildChainBuilder) {
            buildChainBuilder.addBuildStep(new BuildStep(){

                public void execute(BuildContext context) {
                    context.produce((BuildItem)new SubResourcesAsBeansBuildItem());
                }
            }).produces(SubResourcesAsBeansBuildItem.class).build();
        }
    }).withApplicationRoot(jar -> jar.addClasses(new Class[]{RestResource.class, MiddleRestResource.class, RestSubResource.class}));

    @Test
    public void testSubResource() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/sub-resource/Bob/Builder", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Bob Builder"), new Matcher[0])).statusCode(200);
    }

    @Path(value="/")
    public static class RestResource {
        private final MiddleRestResource restSubResource;

        public RestResource(MiddleRestResource restSubResource) {
            this.restSubResource = restSubResource;
        }

        @Path(value="sub-resource/{first}")
        public MiddleRestResource hello(String first) {
            return this.restSubResource;
        }
    }

    public static class MiddleRestResource {
        @Inject
        ResourceContext resourceContext;

        @Path(value="{last}")
        public RestSubResource hello() {
            return (RestSubResource)this.resourceContext.getResource(RestSubResource.class);
        }
    }

    public static class RestSubResource {
        @GET
        public String hello(HttpHeaders headers, @RestPath String first, @RestPath String last) {
            return first + " " + last;
        }
    }
}

