/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.beanparam;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CustomConverterInBeanParamTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{SearchResource.class, FilterData.class, JavaTimeParamConverterProvider.class, LocalDateTimeParamConverter.class}));

    @Test
    void shouldCustomConvertBeUsedForLocalDateTimeInFilterData() {
        LocalDateTime since = LocalDateTime.now();
        String request = since.format(DateTimeFormatter.ISO_DATE_TIME);
        String expected = since.plusYears(1L).format(DateTimeFormatter.ISO_DATE_TIME);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/search?since=" + request), (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)("Got: " + expected)), new Matcher[0]);
    }

    @Path(value="/search")
    public static class SearchResource {
        @GET
        @Produces(value={"text/plain"})
        public String search(@BeanParam FilterData filter) {
            return "Got: " + filter.getSince().plusYears(1L).format(DateTimeFormatter.ISO_DATE_TIME);
        }
    }

    public static class FilterData {
        @QueryParam(value="since")
        private LocalDateTime since;

        public LocalDateTime getSince() {
            return this.since;
        }

        public void setSince(LocalDateTime since) {
            this.since = since;
        }
    }

    @Provider
    public static class JavaTimeParamConverterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType == LocalDateTime.class) {
                return new LocalDateTimeParamConverter();
            }
            return null;
        }
    }

    public static class LocalDateTimeParamConverter
    implements ParamConverter<LocalDateTime> {
        public LocalDateTime fromString(String value) {
            return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
        }

        public String toString(LocalDateTime value) {
            return value.format(DateTimeFormatter.ISO_DATE_TIME);
        }
    }
}

