/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.compress;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.vertx.http.Compressed;
import io.quarkus.vertx.http.Uncompressed;
import io.restassured.RestAssured;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CompressionTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(root -> ((JavaArchive)((JavaArchive)root.addClasses(new Class[]{MyEndpoint.class})).addAsManifestResource((Asset)new StringAsset(MyEndpoint.MESSAGE), "resources/file.txt")).addAsManifestResource((Asset)new StringAsset(MyEndpoint.MESSAGE), "resources/my.doc")).overrideConfigKey("quarkus.http.enable-compression", "true");

    @Test
    public void testEndpoint() {
        this.assertCompressed("/endpoint/compressed");
        this.assertUncompressed("/endpoint/uncompressed");
        this.assertCompressed("/endpoint/compressed-content-type");
        this.assertUncompressed("/endpoint/uncompressed-content-type");
        this.assertCompressed("/endpoint/content-type-implicitly-compressed");
        this.assertCompressed("/endpoint/content-type-with-param-implicitly-compressed");
        this.assertUncompressed("/endpoint/content-type-implicitly-uncompressed");
        this.assertCompressed("/endpoint/content-type-in-produces-compressed");
        this.assertUncompressed("/endpoint/content-type-in-produces-uncompressed");
        this.assertCompressed("/file.txt");
        this.assertUncompressed("/my.doc");
    }

    private void assertCompressed(String path) {
        String bodyStr = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(200)).header("Content-Encoding", "gzip")).extract().asString();
        Assertions.assertEquals((Object)MyEndpoint.MESSAGE, (Object)bodyStr);
    }

    private void assertUncompressed(String path) {
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(200)).extract();
        Assertions.assertTrue((response.header("Content-Encoding") == null ? 1 : 0) != 0, (String)response.headers().toString());
        Assertions.assertEquals((Object)MyEndpoint.MESSAGE, (Object)response.asString());
    }

    @Path(value="endpoint")
    public static class MyEndpoint {
        static String MESSAGE = "Hello compression!";

        @Compressed
        @GET
        @Path(value="compressed")
        public String compressed() {
            return MESSAGE;
        }

        @Uncompressed
        @GET
        @Path(value="uncompressed")
        public String uncompressed() {
            return MESSAGE;
        }

        @Uncompressed
        @GET
        @Path(value="uncompressed-content-type")
        public RestResponse<Object> uncompressedContentType() {
            return RestResponse.ResponseBuilder.ok().entity((Object)MESSAGE).header("Content-type", (Object)"text/plain").build();
        }

        @Compressed
        @GET
        @Path(value="compressed-content-type")
        public RestResponse<Object> compressedContentType() {
            return RestResponse.ResponseBuilder.ok().entity((Object)MESSAGE).header("Content-type", (Object)"foo/bar").build();
        }

        @GET
        @Path(value="content-type-implicitly-compressed")
        public RestResponse<Object> contentTypeImplicitlyCompressed() {
            return RestResponse.ResponseBuilder.ok().entity((Object)MESSAGE).header("Content-type", (Object)"text/plain").build();
        }

        @GET
        @Path(value="content-type-with-param-implicitly-compressed")
        public RestResponse<Object> contentTypeWithParamImplicitlyCompressed() {
            return RestResponse.ResponseBuilder.ok().entity((Object)MESSAGE).header("Content-type", (Object)"text/plain;charset=UTF-8").build();
        }

        @GET
        @Path(value="content-type-implicitly-uncompressed")
        public RestResponse<Object> contentTypeImplicitlyUncompressed() {
            return RestResponse.ResponseBuilder.ok().entity((Object)MESSAGE).header("Content-type", (Object)"foo/bar").build();
        }

        @GET
        @Path(value="content-type-in-produces-compressed")
        public String contentTypeInProducesCompressed() {
            return MESSAGE;
        }

        @Produces(value={"foo/bar"})
        @GET
        @Path(value="content-type-in-produces-uncompressed")
        public String contentTypeInProducesUncompressed() {
            return MESSAGE;
        }
    }
}

