/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.converters;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class RuntimeParamConverterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ParamConverterEndpoint.class, OptionalIntegerParamConverterProvider.class, OptionalIntegerParamConverter.class});
        }
    });

    RuntimeParamConverterTest() {
    }

    @Test
    void sendParameters() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("number", new Object[]{22}).when().get("/param-converter", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello, 22!"), new Matcher[0]);
    }

    @Test
    void doNotSendParameters() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/param-converter", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello, world! No number was provided."), new Matcher[0]);
    }

    @Test
    void sendEmptyParameter() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("number", new Object[]{""}).when().get("/param-converter", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello! You provided an empty number."), new Matcher[0]);
    }

    public static class OptionalIntegerParamConverter
    implements ParamConverter<Optional<Integer>> {
        public Optional<Integer> fromString(String value) {
            if (value == null) {
                return null;
            }
            if (value.trim().isEmpty()) {
                return Optional.empty();
            }
            try {
                int parsedInt = Integer.parseInt(value);
                return Optional.of(parsedInt);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid integer value");
            }
        }

        public String toString(Optional<Integer> value) {
            if (!value.isPresent()) {
                return null;
            }
            Integer intValue = value.get();
            if (intValue == null) {
                return null;
            }
            return intValue.toString();
        }
    }

    @Provider
    @ApplicationScoped
    public static class OptionalIntegerParamConverterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            ParameterizedType parameterizedType;
            Type[] typeArguments;
            if (rawType.equals(Optional.class) && genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && typeArguments[0].equals(Integer.class)) {
                return new OptionalIntegerParamConverter();
            }
            return null;
        }
    }

    @ApplicationScoped
    @Path(value="/param-converter")
    public static class ParamConverterEndpoint {
        @GET
        public jakarta.ws.rs.core.Response greet(@QueryParam(value="number") Optional<Integer> numberOpt) {
            if (numberOpt != null) {
                if (numberOpt.isPresent()) {
                    return jakarta.ws.rs.core.Response.ok((Object)String.format("Hello, %s!", numberOpt.get())).build();
                }
                return jakarta.ws.rs.core.Response.ok((Object)"Hello! You provided an empty number.").build();
            }
            return jakarta.ws.rs.core.Response.ok((Object)"Hello, world! No number was provided.").build();
        }
    }
}

