/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.arc.lookup.LookupUnlessProperty;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ConditionalExceptionMappersTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{AbstractException.class, FirstException.class, SecondException.class, WontBeEnabledMappers.class, WillBeEnabledMappers.class, AlwaysEnabledMappers.class, TestResource.class});
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)RestAssured.get((String)"/first", (Object[])new Object[0]).then()).statusCode(903);
        ((ValidatableResponse)RestAssured.get((String)"/second", (Object[])new Object[0]).then()).statusCode(801);
        ((ValidatableResponse)RestAssured.get((String)"/third", (Object[])new Object[0]).then()).statusCode(555);
    }

    public static class AlwaysEnabledMappers {
        @ServerExceptionMapper(value={FirstException.class}, priority=6000)
        public Response first() {
            return Response.status((int)555).build();
        }

        @ServerExceptionMapper(value={SecondException.class}, priority=6000)
        public Response second() {
            return Response.status((int)555).build();
        }

        @ServerExceptionMapper(value={ThirdException.class}, priority=6000)
        public Uni<Response> third() {
            return Uni.createFrom().item((Object)Response.status((int)555).build());
        }
    }

    @LookupUnlessProperty(name="notexistingproperty", stringValue="true", lookupIfMissing=true)
    public static class WillBeEnabledMappers {
        @ServerExceptionMapper(value={FirstException.class}, priority=5010)
        public Response first() {
            return Response.status((int)902).build();
        }

        @ServerExceptionMapper(value={FirstException.class}, priority=4990)
        public Response firstWithLowerPriority() {
            return Response.status((int)903).build();
        }

        @ServerExceptionMapper(priority=4990)
        public RestResponse<Void> second(SecondException ignored) {
            return RestResponse.status((int)801);
        }
    }

    @IfBuildProfile(value="dummy")
    public static class WontBeEnabledMappers {
        @ServerExceptionMapper(value={FirstException.class})
        public Response first() {
            return Response.status((int)900).build();
        }

        @ServerExceptionMapper(value={FirstException.class}, priority=4900)
        public Response firstWithLowerPriority() {
            return Response.status((int)901).build();
        }

        @ServerExceptionMapper(priority=4900)
        public Response second(SecondException ignored) {
            return Response.status((int)800).build();
        }
    }

    public static class ThirdException
    extends AbstractException {
    }

    public static class SecondException
    extends AbstractException {
    }

    public static class FirstException
    extends AbstractException {
    }

    public static abstract class AbstractException
    extends RuntimeException {
        public AbstractException() {
            this.setStackTrace(new StackTraceElement[0]);
        }
    }

    @Path(value="")
    public static class TestResource {
        @Path(value="first")
        @GET
        public String first() {
            throw new FirstException();
        }

        @Path(value="second")
        @GET
        public String second() {
            throw new SecondException();
        }

        @Path(value="third")
        @GET
        public String third() {
            throw new ThirdException();
        }
    }
}

