/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.resteasy.reactive.server.test.customexceptions.ExtendsUniException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.FirstResource;
import io.quarkus.resteasy.reactive.server.test.customexceptions.MyException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.MyOtherException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.MyOtherExceptionMapper;
import io.quarkus.resteasy.reactive.server.test.customexceptions.OtherUniException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.SecondResource;
import io.quarkus.resteasy.reactive.server.test.customexceptions.SomeBean;
import io.quarkus.resteasy.reactive.server.test.customexceptions.UniException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.UniExceptionMapper;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CustomExceptionMappersTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{FirstResource.class, SecondResource.class, MyException.class, MyOtherException.class, UniException.class, OtherUniException.class, ExtendsUniException.class, MyOtherExceptionMapper.class, UniExceptionMapper.class, SomeBean.class, ExceptionUtil.class});
        }
    });

    @Test
    public void testResourceWithExceptionMapper() {
        ((ValidatableResponse)RestAssured.get((String)"/first?name=IllegalState", (Object[])new Object[0]).then()).statusCode(409);
        ((ValidatableResponse)RestAssured.get((String)"/first?name=IllegalArgument", (Object[])new Object[0]).then()).statusCode(409);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/first?name=My", (Object[])new Object[0]).then()).statusCode(410)).body(Matchers.equalTo((Object)"/first->throwsVariousExceptions"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/first?name=MyOther", (Object[])new Object[0]).then()).statusCode(411);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/first?name=Uni", (Object[])new Object[0]).then()).statusCode(412)).body(Matchers.equalTo((Object)"/first->throwsVariousExceptions"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/first?name=Other", (Object[])new Object[0]).then()).statusCode(500);
    }

    @Test
    public void testResourceWithExceptionMapperAndUniResponse() {
        ((ValidatableResponse)RestAssured.get((String)"/first/uni?name=IllegalState", (Object[])new Object[0]).then()).statusCode(409);
        ((ValidatableResponse)RestAssured.get((String)"/first/uni?name=IllegalArgument", (Object[])new Object[0]).then()).statusCode(409);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/first/uni?name=My", (Object[])new Object[0]).then()).statusCode(410)).body(Matchers.equalTo((Object)"/first/uni->uni"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/first/uni?name=MyOther", (Object[])new Object[0]).then()).statusCode(411);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/first/uni?name=Uni", (Object[])new Object[0]).then()).statusCode(412)).body(Matchers.equalTo((Object)"/first/uni->uni"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/first/uni?name=Other", (Object[])new Object[0]).then()).statusCode(500);
    }

    @Test
    public void testResourceWithoutExceptionMapper() {
        ((ValidatableResponse)RestAssured.get((String)"/second", (Object[])new Object[0]).then()).statusCode(500);
        ((ValidatableResponse)RestAssured.get((String)"/second/other", (Object[])new Object[0]).then()).statusCode(411);
        ((ValidatableResponse)RestAssured.get((String)"/second/uni", (Object[])new Object[0]).then()).statusCode(413);
        ((ValidatableResponse)RestAssured.get((String)"/second/extendsUni", (Object[])new Object[0]).then()).statusCode(414);
    }
}

