/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class GlobalThrowableExceptionMapperTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class, ThrowableExceptionMapper.class});
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)RestAssured.get((String)"/test/throwable", (Object[])new Object[0]).then()).statusCode(415);
    }

    public static class ThrowableExceptionMapper {
        @ServerExceptionMapper
        public Response handleThrowable(Throwable t) {
            return Response.status((int)415).build();
        }
    }

    @Path(value="test")
    public static class Resource {
        @GET
        @Path(value="throwable")
        @Produces(value={"text/plain"})
        public String throwsThrowable() throws Throwable {
            throw ExceptionUtil.removeStackTrace(new Throwable());
        }
    }
}

