/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Path;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.resteasy.reactive.server.UnwrapException;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class UnwrapExceptionTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{FirstException.class, SecondException.class, ThirdException.class, FourthException.class, FifthException.class, SixthException.class, Mappers.class, Resource.class, ExceptionUtil.class});
        }
    });

    @Test
    public void testWrapperWithUnmappedException() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iaeInSecond", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void testMappedExceptionWithoutUnwrappedWrapper() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iseInFirst", new Object[0])).then()).statusCode(500);
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iseInThird", new Object[0])).then()).statusCode(500);
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iseInSixth", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void testWrapperWithMappedException() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iseInSecond", new Object[0])).then()).statusCode(900);
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iseInFourth", new Object[0])).then()).statusCode(900);
        ((ValidatableResponse)((Response)RestAssured.when().get("/hello/iseInFifth", new Object[0])).then()).statusCode(900);
    }

    public static class SixthException
    extends RuntimeException {
        public SixthException(Throwable cause) {
            super(cause);
        }
    }

    public static class FifthException
    extends RuntimeException {
        public FifthException(Throwable cause) {
            super(cause);
        }
    }

    public static class FourthException
    extends SecondException {
        public FourthException(Throwable cause) {
            super(cause);
        }
    }

    public static class ThirdException
    extends Exception {
        public ThirdException(Throwable cause) {
            super(cause);
        }
    }

    @UnwrapException
    public static class SecondException
    extends FirstException {
        public SecondException(Throwable cause) {
            super(cause);
        }
    }

    public static class FirstException
    extends RuntimeException {
        public FirstException(Throwable cause) {
            super(cause);
        }
    }

    @UnwrapException(value={FourthException.class, FifthException.class})
    public static class Mappers {
        @ServerExceptionMapper
        public jakarta.ws.rs.core.Response handleIllegalStateException(IllegalStateException e) {
            return jakarta.ws.rs.core.Response.status((int)900).build();
        }
    }

    @Path(value="hello")
    public static class Resource {
        @Path(value="iseInFirst")
        public String throwsISEAsCauseOfFirstException() {
            throw ExceptionUtil.removeStackTrace(new FirstException(ExceptionUtil.removeStackTrace(new IllegalStateException("dummy"))));
        }

        @Path(value="iseInSecond")
        public String throwsISEAsCauseOfSecondException() {
            throw ExceptionUtil.removeStackTrace(new SecondException(ExceptionUtil.removeStackTrace(new IllegalStateException("dummy"))));
        }

        @Path(value="iaeInSecond")
        public String throwsIAEAsCauseOfSecondException() {
            throw ExceptionUtil.removeStackTrace(new SecondException(ExceptionUtil.removeStackTrace(new IllegalArgumentException("dummy"))));
        }

        @Path(value="iseInThird")
        public String throwsISEAsCauseOfThirdException() throws ThirdException {
            throw ExceptionUtil.removeStackTrace(new ThirdException(ExceptionUtil.removeStackTrace(new IllegalStateException("dummy"))));
        }

        @Path(value="iseInFourth")
        public String throwsISEAsCauseOfFourthException() throws FourthException {
            throw ExceptionUtil.removeStackTrace(new FourthException(ExceptionUtil.removeStackTrace(new IllegalStateException("dummy"))));
        }

        @Path(value="iseInFifth")
        public String throwsISEAsCauseOfFifthException() {
            throw ExceptionUtil.removeStackTrace(new FifthException(ExceptionUtil.removeStackTrace(new IllegalStateException("dummy"))));
        }

        @Path(value="iseInSixth")
        public String throwsISEAsCauseOfSixthException() {
            throw ExceptionUtil.removeStackTrace(new SixthException(ExceptionUtil.removeStackTrace(new IllegalStateException("dummy"))));
        }
    }
}

