/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AsyncResponseWithExceptionAndFiltersTargetTest {
    private static final String RESOURCE_INFO_CLASS_HEADER = "resourceInfoClass";
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{CsResource.class, UniResource.class, CustomResponseFilter.class, DummyException.class, DummyExceptionMapper.class, DummyException2.class, DummyException2.class});
        }
    });

    @Test
    public void csHandled() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/cs/handled", new Object[0])).then()).statusCode(999)).header(RESOURCE_INFO_CLASS_HEADER, CsResource.class.getSimpleName());
    }

    @Test
    public void csHandled2() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/cs/handled2", new Object[0])).then()).statusCode(999)).header(RESOURCE_INFO_CLASS_HEADER, CsResource.class.getSimpleName());
    }

    @Test
    public void csUnhandled() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/cs/unhandled", new Object[0])).then()).statusCode(500)).header(RESOURCE_INFO_CLASS_HEADER, CoreMatchers.nullValue());
    }

    @Test
    public void csUnhandled2() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/cs/unhandled2", new Object[0])).then()).statusCode(204)).header(RESOURCE_INFO_CLASS_HEADER, CsResource.class.getSimpleName());
    }

    @Test
    public void uniHandled() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/uni/handled", new Object[0])).then()).statusCode(999)).header(RESOURCE_INFO_CLASS_HEADER, UniResource.class.getSimpleName());
    }

    @Test
    public void uniHandled2() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/uni/handled2", new Object[0])).then()).statusCode(999)).header(RESOURCE_INFO_CLASS_HEADER, UniResource.class.getSimpleName());
    }

    @Test
    public void uniUnhandled() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/uni/unhandled", new Object[0])).then()).statusCode(500)).header(RESOURCE_INFO_CLASS_HEADER, CoreMatchers.nullValue());
    }

    @Test
    public void uniUnhandled2() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/uni/unhandled2", new Object[0])).then()).statusCode(204)).header(RESOURCE_INFO_CLASS_HEADER, UniResource.class.getSimpleName());
    }

    @Path(value="cs")
    public static class CsResource {
        @GET
        @Path(value="handled")
        public CompletionStage<String> handled() {
            throw new DummyException(true);
        }

        @GET
        @Path(value="handled2")
        public CompletionStage<String> handled2() {
            throw new DummyException2(true);
        }

        @GET
        @Path(value="unhandled")
        public CompletionStage<String> unhandled() {
            throw new DummyException(false);
        }

        @GET
        @Path(value="unhandled2")
        public CompletionStage<String> unhandled2() {
            throw new DummyException2(false);
        }
    }

    @Path(value="uni")
    public static class UniResource {
        @GET
        @Path(value="handled")
        public CompletionStage<String> handled() {
            throw new DummyException(true);
        }

        @GET
        @Path(value="handled2")
        public CompletionStage<String> handled2() {
            throw new DummyException2(true);
        }

        @GET
        @Path(value="unhandled")
        public CompletionStage<String> unhandled() {
            throw new DummyException(false);
        }

        @GET
        @Path(value="unhandled2")
        public CompletionStage<String> unhandled2() {
            throw new DummyException2(false);
        }
    }

    public static class DummyException2
    extends RuntimeException {
        private final boolean handle;

        public DummyException2(boolean handle) {
            super("dummy2");
            this.handle = handle;
            this.setStackTrace(new StackTraceElement[0]);
        }

        public boolean isHandle() {
            return this.handle;
        }
    }

    public static class DummyException
    extends RuntimeException {
        private final boolean handle;

        public DummyException(boolean handle) {
            super("dummy");
            this.handle = handle;
            this.setStackTrace(new StackTraceElement[0]);
        }

        public boolean isHandle() {
            return this.handle;
        }
    }

    public static class DummyExceptionMapper2 {
        @ServerExceptionMapper
        public jakarta.ws.rs.core.Response handle(DummyException2 ex) {
            if (ex.isHandle()) {
                return jakarta.ws.rs.core.Response.status((int)999).build();
            }
            return null;
        }
    }

    @Provider
    public static class DummyExceptionMapper
    implements ExceptionMapper<DummyException> {
        public jakarta.ws.rs.core.Response toResponse(DummyException exception) {
            if (exception.isHandle()) {
                return jakarta.ws.rs.core.Response.status((int)999).build();
            }
            throw exception;
        }
    }

    public static class CustomResponseFilter {
        @ServerResponseFilter
        public void filter(ContainerResponseContext responseContext, ResourceInfo resourceInfo) {
            responseContext.getHeaders().add((Object)AsyncResponseWithExceptionAndFiltersTargetTest.RESOURCE_INFO_CLASS_HEADER, (Object)resourceInfo.getResourceClass().getSimpleName());
        }
    }
}

