/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.arc.lookup.LookupIfProperty;
import io.quarkus.arc.lookup.LookupUnlessProperty;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ConditionalBeanFiltersTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{WontBeEnabledFilter.class, WillBeEnabledFilter.class, AlwaysEnabledFilter.class, TestResource.class});
        }
    });

    @Test
    public void testExpectedFilters() {
        List responseFiltersValues = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/filters", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"void-on,response-on,uni-on,void-lookup-on,always"), new Matcher[0])).extract().headers().getList("response-filters").stream().map(Header::getValue).collect(Collectors.toList());
        Assertions.assertThat(responseFiltersValues).containsOnly((Object[])new String[]{"always", "void-lookup-on", "void-on", "uni-on"});
    }

    @Singleton
    public static class AlwaysEnabledFilter {
        @ServerRequestFilter(priority=5100)
        public void alwaysRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"always");
        }

        @ServerResponseFilter(priority=5100)
        public void voidResponseFilter(ContainerResponseContext ctx) {
            ctx.getHeaders().add((Object)"response-filters", (Object)"always");
        }
    }

    @LookupUnlessProperty(name="notexistingproperty", stringValue="true", lookupIfMissing=true)
    public static class WillBeEnabledLookupPropertyFilter {
        @ServerRequestFilter(priority=5020)
        public void voidRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"void-lookup-on");
        }

        @ServerResponseFilter(priority=5020)
        public void voidResponseFilter(ContainerResponseContext ctx) {
            ctx.getHeaders().add((Object)"response-filters", (Object)"void-lookup-on");
        }
    }

    @LookupIfProperty(name="notexistingproperty", stringValue="true")
    public static class WontBeEnabledLookupPropertyFilter {
        @ServerRequestFilter(priority=5010)
        public void voidRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"void-lookup-off");
        }

        @ServerResponseFilter
        public void voidResponseFilter(ContainerResponseContext ctx) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)true);
        }
    }

    @IfBuildProfile(value="test")
    public static class WillBeEnabledFilter {
        @ServerRequestFilter(priority=5004)
        public void voidRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"void-on");
        }

        @ServerRequestFilter(priority=5005)
        public Optional<Response> responseTypeRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"response-on");
            return Optional.empty();
        }

        @ServerRequestFilter(priority=5006)
        public Uni<Response> uniRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"uni-on");
            return Uni.createFrom().nullItem();
        }

        @ServerResponseFilter(priority=5004)
        public void voidResponseFilter(ContainerResponseContext ctx) {
            ctx.getHeaders().add((Object)"response-filters", (Object)"void-on");
        }

        @ServerResponseFilter(priority=5006)
        public Uni<Void> uniResponseFilter(ContainerResponseContext ctx) {
            ctx.getHeaders().add((Object)"response-filters", (Object)"uni-on");
            return Uni.createFrom().nullItem();
        }
    }

    @IfBuildProperty(name="notexistingproperty", stringValue="true")
    public static class WontBeEnabledFilter {
        @ServerRequestFilter(priority=5001)
        public void voidRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"void-off");
        }

        @ServerRequestFilter(priority=5002)
        public Response responseTypeRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"response-off");
            return null;
        }

        @ServerRequestFilter(priority=5003)
        public Uni<Void> uniRequestFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"request-filters", (Object)"uni-off");
            return Uni.createFrom().nullItem();
        }

        @ServerResponseFilter
        public void voidResponseFilter(ContainerResponseContext ctx) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)true);
        }

        @ServerResponseFilter
        public Uni<Void> uniResponseFilter(ContainerResponseContext ctx) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)true);
            return Uni.createFrom().nullItem();
        }
    }

    @Path(value="test")
    public static class TestResource {
        @Path(value="filters")
        @GET
        public String filters(HttpHeaders headers) {
            return String.join((CharSequence)",", headers.getRequestHeader("request-filters"));
        }
    }
}

