/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.resteasy.reactive.server.test.customproviders.NotFoundExeptionMapper;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerResponseContext;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class FilterWithPathParamsTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{HelloResource.class, Filters.class, NotFoundExeptionMapper.class});
        }
    });

    @Test
    public void testNonExistingPath() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/dummy", new Object[0])).then()).statusCode(404)).header("path-params", CoreMatchers.is((Object)"0"));
    }

    @Test
    public void testNoPathParamsPathNoAbort() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello", new Object[0])).then()).statusCode(200)).header("path-params", CoreMatchers.is((Object)"0"));
    }

    @Test
    public void testNoPathParamsPathWithAbort() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("abort", (Object)"true", new Object[0]).when().get("/hello", new Object[0])).then()).statusCode(401)).header("path-params", CoreMatchers.is((Object)"0"));
    }

    @Test
    public void testPathParamsPathNoAbort() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello/resteasy", new Object[0])).then()).statusCode(200)).header("path-params", CoreMatchers.is((Object)"1"));
    }

    @Test
    public void testPathParamsPathWithAbort() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("abort", (Object)"true", new Object[0]).when().get("/hello/resteasy", new Object[0])).then()).statusCode(401)).header("path-params", CoreMatchers.is((Object)"1"));
    }

    public static class Filters {
        @ServerRequestFilter
        public Uni<jakarta.ws.rs.core.Response> filter(ResteasyReactiveContainerRequestContext requestContext) {
            if ("true".equals(requestContext.getHeaders().getFirst((Object)"abort"))) {
                requestContext.getUriInfo().getPathParameters();
                return Uni.createFrom().item((Object)jakarta.ws.rs.core.Response.status((int)401).build());
            }
            return null;
        }

        @ServerResponseFilter
        public void responseFilter(ResteasyReactiveContainerRequestContext requestContext, ContainerResponseContext responseContext) {
            responseContext.getHeaders().add((Object)"path-params", (Object)requestContext.getUriInfo().getPathParameters().size());
        }
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String hello() {
            return "hello";
        }

        @Path(value="{name}")
        @GET
        public String helloName(String name) {
            return name;
        }
    }
}

