/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.test.QuarkusUnitTest;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.annotation.Priority;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class InvalidNonBlockingFiltersTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{StandardBlockingRequestFilter.class, StandardNonBlockingRequestFilter.class, DummyResource.class});
        }
    }).assertException(t -> Assertions.assertTrue((boolean)t.getMessage().contains("StandardNonBlockingRequestFilter")));

    @Test
    public void test() {
        Assertions.fail((String)"Should never have been called");
    }

    @NonBlocking
    @Provider
    @Priority(value=5001)
    public static class StandardNonBlockingRequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
        }
    }

    @Provider
    public static class StandardBlockingRequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
        }
    }

    @Path(value="dummy")
    public static class DummyResource {
        @Blocking
        @Path(value="blocking")
        @GET
        public Response blocking() {
            return Response.ok().build();
        }
    }
}

